/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import io.prestosql.hadoop.$internal.com.google.common.collect.Sets;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class FinalizerService {
    public static final Log log = LogFactory.getLog(FinalizerService.class);
    private static final long REMOVE_TIMEOUT = 5000L;
    private static FinalizerService INSTANCE;
    private final Set<FinalizerReference> finalizers = Sets.newSetFromMap(new ConcurrentHashMap());
    private final ReferenceQueue<Object> finalizerQueue = new ReferenceQueue();
    private Thread finalizerThread;

    private FinalizerService() {
    }

    public static synchronized FinalizerService getInstance() {
        if (INSTANCE == null) {
            FinalizerService finalizer = new FinalizerService();
            finalizer.start();
            INSTANCE = finalizer;
        }
        return INSTANCE;
    }

    private void start() {
        if (this.finalizerThread != null) {
            return;
        }
        this.finalizerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                FinalizerService.this.processFinalizerQueue();
            }
        });
        this.finalizerThread.setDaemon(true);
        this.finalizerThread.setName("hadoop-finalizer-service");
        this.finalizerThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error("Uncaught exception in finalizer thread", e);
            }
        });
        this.finalizerThread.start();
    }

    public void addFinalizer(Object referent, Runnable cleanup) {
        Objects.requireNonNull(referent, "referent is null");
        Objects.requireNonNull(cleanup, "cleanup is null");
        this.finalizers.add(new FinalizerReference(referent, this.finalizerQueue, cleanup));
    }

    private void processFinalizerQueue() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                FinalizerReference finalizer = (FinalizerReference)this.finalizerQueue.remove(5000L);
                if (finalizer == null) continue;
                this.finalizers.remove(finalizer);
                finalizer.cleanup();
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                log.error("Exception in finalizer queue processor", e);
            }
        }
    }

    private static class FinalizerReference
    extends PhantomReference<Object> {
        private final Runnable cleanup;
        private final AtomicBoolean executed = new AtomicBoolean();

        public FinalizerReference(Object referent, ReferenceQueue<Object> queue, Runnable cleanup) {
            super(Objects.requireNonNull(referent, "referent is null"), Objects.requireNonNull(queue, "queue is null"));
            this.cleanup = Objects.requireNonNull(cleanup, "cleanup is null");
        }

        public void cleanup() {
            if (this.executed.compareAndSet(false, true)) {
                this.cleanup.run();
            }
        }
    }
}

