/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.commons.configuration.event;

import io.prestosql.hadoop.$internal.org.apache.commons.configuration.event.ConfigurationErrorEvent;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration.event.ConfigurationErrorListener;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration.event.ConfigurationEvent;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration.event.ConfigurationListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class EventSource {
    private Collection listeners;
    private Collection errorListeners;
    private int detailEvents;

    public EventSource() {
        this.initListeners();
    }

    public void addConfigurationListener(ConfigurationListener l) {
        EventSource.doAddListener(this.listeners, l);
    }

    public boolean removeConfigurationListener(ConfigurationListener l) {
        return EventSource.doRemoveListener(this.listeners, l);
    }

    public Collection getConfigurationListeners() {
        return EventSource.doGetListeners(this.listeners);
    }

    public void clearConfigurationListeners() {
        EventSource.doClearListeners(this.listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDetailEvents() {
        Collection collection = this.listeners;
        synchronized (collection) {
            return this.detailEvents > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetailEvents(boolean enable) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.detailEvents = enable ? ++this.detailEvents : --this.detailEvents;
        }
    }

    public void addErrorListener(ConfigurationErrorListener l) {
        EventSource.doAddListener(this.errorListeners, l);
    }

    public boolean removeErrorListener(ConfigurationErrorListener l) {
        return EventSource.doRemoveListener(this.errorListeners, l);
    }

    public void clearErrorListeners() {
        EventSource.doClearListeners(this.errorListeners);
    }

    public Collection getErrorListeners() {
        return EventSource.doGetListeners(this.errorListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(int type, String propName, Object propValue, boolean before) {
        ArrayList listenersToCall = null;
        Collection collection = this.listeners;
        synchronized (collection) {
            if (this.detailEvents >= 0 && this.listeners.size() > 0) {
                listenersToCall = new ArrayList(this.listeners);
            }
        }
        if (listenersToCall != null) {
            ConfigurationEvent event = this.createEvent(type, propName, propValue, before);
            Iterator it = listenersToCall.iterator();
            while (it.hasNext()) {
                ((ConfigurationListener)it.next()).configurationChanged(event);
            }
        }
    }

    protected ConfigurationEvent createEvent(int type, String propName, Object propValue, boolean before) {
        return new ConfigurationEvent(this, type, propName, propValue, before);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireError(int type, String propName, Object propValue, Throwable ex) {
        ArrayList listenersToCall = null;
        Collection collection = this.errorListeners;
        synchronized (collection) {
            if (this.errorListeners.size() > 0) {
                listenersToCall = new ArrayList(this.errorListeners);
            }
        }
        if (listenersToCall != null) {
            ConfigurationErrorEvent event = this.createErrorEvent(type, propName, propValue, ex);
            Iterator it = listenersToCall.iterator();
            while (it.hasNext()) {
                ((ConfigurationErrorListener)it.next()).configurationError(event);
            }
        }
    }

    protected ConfigurationErrorEvent createErrorEvent(int type, String propName, Object propValue, Throwable ex) {
        return new ConfigurationErrorEvent((Object)this, type, propName, propValue, ex);
    }

    protected Object clone() throws CloneNotSupportedException {
        EventSource copy = (EventSource)super.clone();
        copy.initListeners();
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doAddListener(Collection listeners, Object l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener must not be null!");
        }
        Collection collection = listeners;
        synchronized (collection) {
            listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doRemoveListener(Collection listeners, Object l) {
        Collection collection = listeners;
        synchronized (collection) {
            return listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doClearListeners(Collection listeners) {
        Collection collection = listeners;
        synchronized (collection) {
            listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection doGetListeners(Collection listeners) {
        Collection collection = listeners;
        synchronized (collection) {
            return Collections.unmodifiableCollection(new ArrayList(listeners));
        }
    }

    private void initListeners() {
        this.listeners = new LinkedList();
        this.errorListeners = new LinkedList();
    }
}

