/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.LocationMode;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RetryExponentialRetry;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RetryPolicyFactory;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.util.Date;

public abstract class RequestOptions {
    private RetryPolicyFactory retryPolicyFactory;
    private Integer timeoutIntervalInMs;
    private LocationMode locationMode;
    private Integer maximumExecutionTimeInMs;
    private Long operationExpiryTime;

    public RequestOptions() {
    }

    public RequestOptions(RequestOptions other) {
        if (other != null) {
            this.setRetryPolicyFactory(other.getRetryPolicyFactory());
            this.setTimeoutIntervalInMs(other.getTimeoutIntervalInMs());
            this.setLocationMode(other.getLocationMode());
            this.setMaximumExecutionTimeInMs(other.getMaximumExecutionTimeInMs());
            this.setOperationExpiryTimeInMs(other.getOperationExpiryTimeInMs());
        }
    }

    protected static final RequestOptions applyBaseDefaultsInternal(RequestOptions modifiedOptions) {
        Utility.assertNotNull("modifiedOptions", modifiedOptions);
        if (modifiedOptions.getRetryPolicyFactory() == null) {
            modifiedOptions.setRetryPolicyFactory(new RetryExponentialRetry());
        }
        if (modifiedOptions.getLocationMode() == null) {
            modifiedOptions.setLocationMode(LocationMode.PRIMARY_ONLY);
        }
        return modifiedOptions;
    }

    protected static final RequestOptions populateRequestOptions(RequestOptions modifiedOptions, RequestOptions clientOptions, boolean setStartTime) {
        if (modifiedOptions.getRetryPolicyFactory() == null) {
            modifiedOptions.setRetryPolicyFactory(clientOptions.getRetryPolicyFactory());
        }
        if (modifiedOptions.getLocationMode() == null) {
            modifiedOptions.setLocationMode(clientOptions.getLocationMode());
        }
        if (modifiedOptions.getTimeoutIntervalInMs() == null) {
            modifiedOptions.setTimeoutIntervalInMs(clientOptions.getTimeoutIntervalInMs());
        }
        if (modifiedOptions.getMaximumExecutionTimeInMs() == null) {
            modifiedOptions.setMaximumExecutionTimeInMs(clientOptions.getMaximumExecutionTimeInMs());
        }
        if (modifiedOptions.getMaximumExecutionTimeInMs() != null && modifiedOptions.getOperationExpiryTimeInMs() == null && setStartTime) {
            modifiedOptions.setOperationExpiryTimeInMs(new Date().getTime() + (long)modifiedOptions.getMaximumExecutionTimeInMs().intValue());
        }
        return modifiedOptions;
    }

    public final RetryPolicyFactory getRetryPolicyFactory() {
        return this.retryPolicyFactory;
    }

    public final Integer getTimeoutIntervalInMs() {
        return this.timeoutIntervalInMs;
    }

    public final LocationMode getLocationMode() {
        return this.locationMode;
    }

    public Integer getMaximumExecutionTimeInMs() {
        return this.maximumExecutionTimeInMs;
    }

    public Long getOperationExpiryTimeInMs() {
        return this.operationExpiryTime;
    }

    public final void setRetryPolicyFactory(RetryPolicyFactory retryPolicyFactory) {
        this.retryPolicyFactory = retryPolicyFactory;
    }

    public final void setTimeoutIntervalInMs(Integer timeoutIntervalInMs) {
        this.timeoutIntervalInMs = timeoutIntervalInMs;
    }

    public void setLocationMode(LocationMode locationMode) {
        this.locationMode = locationMode;
    }

    public void setMaximumExecutionTimeInMs(Integer maximumExecutionTimeInMs) {
        this.maximumExecutionTimeInMs = maximumExecutionTimeInMs;
    }

    private void setOperationExpiryTimeInMs(Long operationExpiryTime) {
        this.operationExpiryTime = operationExpiryTime;
    }
}

