/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import io.trino.plugin.hive.s3select.S3SelectDataType;
import io.trino.plugin.hive.s3select.S3SelectLineRecordReader;
import io.trino.plugin.hive.s3select.TrinoS3ClientFactory;
import io.trino.plugin.hive.s3select.csv.S3SelectCsvRecordReader;
import io.trino.plugin.hive.s3select.json.S3SelectJsonRecordReader;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class S3SelectLineRecordReaderProvider {
    private S3SelectLineRecordReaderProvider() {
    }

    public static Optional<S3SelectLineRecordReader> get(Configuration configuration, Path path, long start, long length, Properties schema, String ionSqlQuery, TrinoS3ClientFactory s3ClientFactory, S3SelectDataType dataType) {
        switch (dataType) {
            case CSV: {
                return Optional.of(new S3SelectCsvRecordReader(configuration, path, start, length, schema, ionSqlQuery, s3ClientFactory));
            }
            case JSON: {
                return Optional.of(new S3SelectJsonRecordReader(configuration, path, start, length, schema, ionSqlQuery, s3ClientFactory));
            }
        }
        return Optional.empty();
    }
}

