/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.s3select.S3SelectDataType;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.joda.time.Chronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class IonSqlQueryBuilder {
    private static final DateTimeFormatter FORMATTER = ISODateTimeFormat.date().withChronology((Chronology)ISOChronology.getInstanceUTC());
    private static final String DATA_SOURCE = "S3Object s";
    private final TypeManager typeManager;
    private final S3SelectDataType s3SelectDataType;
    private final String nullPredicate;
    private final String notNullPredicate;

    public IonSqlQueryBuilder(TypeManager typeManager, S3SelectDataType s3SelectDataType, Optional<String> optionalNullCharacterEncoding) {
        if (optionalNullCharacterEncoding.isPresent()) {
            Preconditions.checkArgument((s3SelectDataType == S3SelectDataType.CSV ? 1 : 0) != 0, (Object)"Null character encoding should only be provided for CSV data");
        }
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.s3SelectDataType = Objects.requireNonNull(s3SelectDataType, "s3SelectDataType is null");
        String nullCharacterEncoding = optionalNullCharacterEncoding.orElse("");
        this.nullPredicate = switch (s3SelectDataType) {
            default -> throw new IncompatibleClassChangeError();
            case S3SelectDataType.JSON -> "IS NULL";
            case S3SelectDataType.CSV -> "= '%s'".formatted(nullCharacterEncoding);
        };
        this.notNullPredicate = switch (s3SelectDataType) {
            default -> throw new IncompatibleClassChangeError();
            case S3SelectDataType.JSON -> "IS NOT NULL";
            case S3SelectDataType.CSV -> "!= '%s'".formatted(nullCharacterEncoding);
        };
    }

    public String buildSql(List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> tupleDomain) {
        columns.forEach(column -> Preconditions.checkArgument((boolean)column.isBaseColumn(), (String)"%s is not a base column", (Object)column));
        tupleDomain.getDomains().ifPresent(domains -> domains.keySet().forEach(column -> Preconditions.checkArgument((boolean)column.isBaseColumn(), (String)"%s is not a base column", (Object)column)));
        StringBuilder sql = new StringBuilder("SELECT ");
        if (columns.isEmpty()) {
            sql.append("' '");
        } else {
            String columnNames = columns.stream().map(this::getFullyQualifiedColumnName).collect(Collectors.joining(", "));
            sql.append(columnNames);
        }
        sql.append(" FROM ");
        sql.append(DATA_SOURCE);
        List<String> clauses = this.toConjuncts(columns, tupleDomain);
        if (!clauses.isEmpty()) {
            sql.append(" WHERE ").append(Joiner.on((String)" AND ").join(clauses));
        }
        return sql.toString();
    }

    private String getFullyQualifiedColumnName(HiveColumnHandle column) {
        return switch (this.s3SelectDataType) {
            default -> throw new IncompatibleClassChangeError();
            case S3SelectDataType.JSON -> "s.%s".formatted(column.getBaseColumnName());
            case S3SelectDataType.CSV -> "s._%d".formatted(column.getBaseHiveColumnIndex() + 1);
        };
    }

    private List<String> toConjuncts(List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> tupleDomain) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (HiveColumnHandle column : columns) {
            Domain domain;
            Type type = column.getHiveType().getType(this.typeManager);
            if (!tupleDomain.getDomains().isPresent() || !IonSqlQueryBuilder.isSupported(type) || (domain = (Domain)((Map)tupleDomain.getDomains().get()).get(column)) == null) continue;
            builder.add((Object)this.toPredicate(domain, type, column));
        }
        return builder.build();
    }

    private static boolean isSupported(Type type) {
        Type validType = Objects.requireNonNull(type, "type is null");
        return validType.equals(BigintType.BIGINT) || validType.equals(TinyintType.TINYINT) || validType.equals(SmallintType.SMALLINT) || validType.equals(IntegerType.INTEGER) || validType.equals(BooleanType.BOOLEAN) || validType.equals(DateType.DATE) || validType instanceof VarcharType;
    }

    private String toPredicate(Domain domain, Type type, HiveColumnHandle column) {
        Preconditions.checkArgument((boolean)domain.getType().isOrderable(), (Object)"Domain type must be orderable");
        if (domain.getValues().isNone()) {
            if (domain.isNullAllowed()) {
                return this.getFullyQualifiedColumnName(column) + " " + this.nullPredicate;
            }
            return "FALSE";
        }
        if (domain.getValues().isAll()) {
            if (domain.isNullAllowed()) {
                return "TRUE";
            }
            return this.getFullyQualifiedColumnName(column) + " " + this.notNullPredicate;
        }
        ArrayList<Object> disjuncts = new ArrayList<Object>();
        ArrayList<Object> singleValues = new ArrayList<Object>();
        for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                singleValues.add(range.getSingleValue());
                continue;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!range.isLowUnbounded()) {
                arrayList.add(this.toPredicate(range.isLowInclusive() ? ">=" : ">", range.getLowBoundedValue(), type, column));
            }
            if (!range.isHighUnbounded()) {
                arrayList.add(this.toPredicate(range.isHighInclusive() ? "<=" : "<", range.getHighBoundedValue(), type, column));
            }
            Preconditions.checkState((!arrayList.isEmpty() ? 1 : 0) != 0);
            if (arrayList.size() == 1) {
                disjuncts.add("%s %s AND %s".formatted(this.getFullyQualifiedColumnName(column), this.notNullPredicate, Iterables.getOnlyElement(arrayList)));
                continue;
            }
            disjuncts.add("(%s %s AND %s)".formatted(this.getFullyQualifiedColumnName(column), this.notNullPredicate, Joiner.on((String)" AND ").join(arrayList)));
        }
        if (singleValues.size() == 1) {
            disjuncts.add("%s %s AND %s".formatted(this.getFullyQualifiedColumnName(column), this.notNullPredicate, this.toPredicate("=", Iterables.getOnlyElement(singleValues), type, column)));
        } else if (singleValues.size() > 1) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object e : singleValues) {
                IonSqlQueryBuilder.checkType(type);
                values.add(IonSqlQueryBuilder.valueToQuery(type, e));
            }
            disjuncts.add("%s %s AND %s IN (%s)".formatted(this.getFullyQualifiedColumnName(column), this.notNullPredicate, this.createColumn(type, column), Joiner.on((String)",").join(values)));
        }
        Preconditions.checkState((!disjuncts.isEmpty() ? 1 : 0) != 0);
        if (domain.isNullAllowed()) {
            disjuncts.add(this.getFullyQualifiedColumnName(column) + " " + this.nullPredicate);
        }
        return "(" + Joiner.on((String)" OR ").join(disjuncts) + ")";
    }

    private String toPredicate(String operator, Object value, Type type, HiveColumnHandle column) {
        IonSqlQueryBuilder.checkType(type);
        return String.format("%s %s %s", this.createColumn(type, column), operator, IonSqlQueryBuilder.valueToQuery(type, value));
    }

    private static void checkType(Type type) {
        Preconditions.checkArgument((boolean)IonSqlQueryBuilder.isSupported(type), (String)"Type not supported: %s", (Object)type);
    }

    private static String valueToQuery(Type type, Object value) {
        if (type.equals(BigintType.BIGINT)) {
            return String.valueOf((Long)value);
        }
        if (type.equals(IntegerType.INTEGER)) {
            return String.valueOf(Math.toIntExact((Long)value));
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return String.valueOf(Shorts.checkedCast((long)((Long)value)));
        }
        if (type.equals(TinyintType.TINYINT)) {
            return String.valueOf(SignedBytes.checkedCast((long)((Long)value)));
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return String.valueOf((Boolean)value);
        }
        if (type.equals(DateType.DATE)) {
            return "'" + FORMATTER.print(TimeUnit.DAYS.toMillis((Long)value)) + "'";
        }
        if (type.equals(VarcharType.VARCHAR)) {
            return "'" + ((Slice)value).toStringUtf8().replace("'", "''") + "'";
        }
        return "'" + ((Slice)value).toStringUtf8() + "'";
    }

    private String createColumn(Type type, HiveColumnHandle columnHandle) {
        String column = this.getFullyQualifiedColumnName(columnHandle);
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            return "CAST(" + column + " AS INT)";
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return "CAST(" + column + " AS BOOL)";
        }
        return column;
    }
}

