/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.units.Duration;
import java.time.Clock;
import java.util.Objects;

@ThreadSafe
final class CoalescingCounter {
    private final Clock clock;
    private final long coalescingDurationMillis;
    @GuardedBy(value="this")
    private long count;
    @GuardedBy(value="this")
    private long lastUpdateTime;

    public CoalescingCounter(Duration coalescingDuration) {
        this(Clock.systemUTC(), coalescingDuration);
    }

    @VisibleForTesting
    CoalescingCounter(Clock clock, Duration coalescingDuration) {
        this.clock = Objects.requireNonNull(clock, "clock is null");
        this.coalescingDurationMillis = coalescingDuration.toMillis();
    }

    private synchronized void increment() {
        long now = this.clock.instant().toEpochMilli();
        if (this.lastUpdateTime + this.coalescingDurationMillis >= now) {
            return;
        }
        ++this.count;
        this.lastUpdateTime = now;
    }

    public synchronized long get() {
        return this.count;
    }

    public synchronized long incrementAndGet() {
        this.increment();
        return this.get();
    }
}

