/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.plugin.hive.metastore.glue.ForGlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueClientUtil;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class HiveGlueClientProvider
implements Provider<AWSGlueAsync> {
    private final GlueMetastoreStats stats;
    private final AWSCredentialsProvider credentialsProvider;
    private final GlueHiveMetastoreConfig glueConfig;
    private final Set<RequestHandler2> requestHandlers;

    @Inject
    public HiveGlueClientProvider(@ForGlueHiveMetastore GlueMetastoreStats stats, AWSCredentialsProvider credentialsProvider, @ForGlueHiveMetastore Set<RequestHandler2> requestHandlers, GlueHiveMetastoreConfig glueConfig) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.credentialsProvider = Objects.requireNonNull(credentialsProvider, "credentialsProvider is null");
        this.requestHandlers = ImmutableSet.copyOf((Collection)Objects.requireNonNull(requestHandlers, "requestHandlers is null"));
        this.glueConfig = glueConfig;
    }

    public AWSGlueAsync get() {
        return GlueClientUtil.createAsyncGlueClient(this.glueConfig, this.credentialsProvider, this.requestHandlers, this.stats.newRequestMetricsCollector());
    }
}

