/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import io.trino.plugin.hive.metastore.BooleanStatistics;
import io.trino.plugin.hive.metastore.DateStatistics;
import io.trino.plugin.hive.metastore.DecimalStatistics;
import io.trino.plugin.hive.metastore.DoubleStatistics;
import io.trino.plugin.hive.metastore.IntegerStatistics;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;

@Immutable
public class HiveColumnStatistics {
    private static final HiveColumnStatistics EMPTY = HiveColumnStatistics.builder().build();
    private final Optional<IntegerStatistics> integerStatistics;
    private final Optional<DoubleStatistics> doubleStatistics;
    private final Optional<DecimalStatistics> decimalStatistics;
    private final Optional<DateStatistics> dateStatistics;
    private final Optional<BooleanStatistics> booleanStatistics;
    private final OptionalLong maxValueSizeInBytes;
    private final OptionalLong totalSizeInBytes;
    private final OptionalLong nullsCount;
    private final OptionalLong distinctValuesCount;

    public static HiveColumnStatistics empty() {
        return EMPTY;
    }

    @JsonCreator
    public HiveColumnStatistics(@JsonProperty(value="integerStatistics") Optional<IntegerStatistics> integerStatistics, @JsonProperty(value="doubleStatistics") Optional<DoubleStatistics> doubleStatistics, @JsonProperty(value="decimalStatistics") Optional<DecimalStatistics> decimalStatistics, @JsonProperty(value="dateStatistics") Optional<DateStatistics> dateStatistics, @JsonProperty(value="booleanStatistics") Optional<BooleanStatistics> booleanStatistics, @JsonProperty(value="maxValueSizeInBytes") OptionalLong maxValueSizeInBytes, @JsonProperty(value="totalSizeInBytes") OptionalLong totalSizeInBytes, @JsonProperty(value="nullsCount") OptionalLong nullsCount, @JsonProperty(value="distinctValuesCount") OptionalLong distinctValuesCount) {
        this.integerStatistics = Objects.requireNonNull(integerStatistics, "integerStatistics is null");
        this.doubleStatistics = Objects.requireNonNull(doubleStatistics, "doubleStatistics is null");
        this.decimalStatistics = Objects.requireNonNull(decimalStatistics, "decimalStatistics is null");
        this.dateStatistics = Objects.requireNonNull(dateStatistics, "dateStatistics is null");
        this.booleanStatistics = Objects.requireNonNull(booleanStatistics, "booleanStatistics is null");
        this.maxValueSizeInBytes = Objects.requireNonNull(maxValueSizeInBytes, "maxValueSizeInBytes is null");
        this.totalSizeInBytes = Objects.requireNonNull(totalSizeInBytes, "totalSizeInBytes is null");
        this.nullsCount = Objects.requireNonNull(nullsCount, "nullsCount is null");
        this.distinctValuesCount = Objects.requireNonNull(distinctValuesCount, "distinctValuesCount is null");
        ArrayList presentStatistics = new ArrayList();
        integerStatistics.ifPresent(s -> presentStatistics.add("integerStatistics"));
        doubleStatistics.ifPresent(s -> presentStatistics.add("doubleStatistics"));
        decimalStatistics.ifPresent(s -> presentStatistics.add("decimalStatistics"));
        dateStatistics.ifPresent(s -> presentStatistics.add("dateStatistics"));
        booleanStatistics.ifPresent(s -> presentStatistics.add("booleanStatistics"));
        Preconditions.checkArgument((presentStatistics.size() <= 1 ? 1 : 0) != 0, (String)"multiple type specific statistic objects are present: %s", presentStatistics);
    }

    @JsonProperty
    public Optional<IntegerStatistics> getIntegerStatistics() {
        return this.integerStatistics;
    }

    @JsonProperty
    public Optional<DoubleStatistics> getDoubleStatistics() {
        return this.doubleStatistics;
    }

    @JsonProperty
    public Optional<DecimalStatistics> getDecimalStatistics() {
        return this.decimalStatistics;
    }

    @JsonProperty
    public Optional<DateStatistics> getDateStatistics() {
        return this.dateStatistics;
    }

    @JsonProperty
    public Optional<BooleanStatistics> getBooleanStatistics() {
        return this.booleanStatistics;
    }

    @JsonProperty
    public OptionalLong getMaxValueSizeInBytes() {
        return this.maxValueSizeInBytes;
    }

    @JsonProperty
    public OptionalLong getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    @JsonProperty
    public OptionalLong getNullsCount() {
        return this.nullsCount;
    }

    @JsonProperty
    public OptionalLong getDistinctValuesCount() {
        return this.distinctValuesCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveColumnStatistics that = (HiveColumnStatistics)o;
        return Objects.equals(this.integerStatistics, that.integerStatistics) && Objects.equals(this.doubleStatistics, that.doubleStatistics) && Objects.equals(this.decimalStatistics, that.decimalStatistics) && Objects.equals(this.dateStatistics, that.dateStatistics) && Objects.equals(this.booleanStatistics, that.booleanStatistics) && Objects.equals(this.maxValueSizeInBytes, that.maxValueSizeInBytes) && Objects.equals(this.totalSizeInBytes, that.totalSizeInBytes) && Objects.equals(this.nullsCount, that.nullsCount) && Objects.equals(this.distinctValuesCount, that.distinctValuesCount);
    }

    public int hashCode() {
        return Objects.hash(this.integerStatistics, this.doubleStatistics, this.decimalStatistics, this.dateStatistics, this.booleanStatistics, this.maxValueSizeInBytes, this.totalSizeInBytes, this.nullsCount, this.distinctValuesCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("integerStatistics", this.integerStatistics).add("doubleStatistics", this.doubleStatistics).add("decimalStatistics", this.decimalStatistics).add("dateStatistics", this.dateStatistics).add("booleanStatistics", this.booleanStatistics).add("maxValueSizeInBytes", (Object)this.maxValueSizeInBytes).add("totalSizeInBytes", (Object)this.totalSizeInBytes).add("nullsCount", (Object)this.nullsCount).add("distinctValuesCount", (Object)this.distinctValuesCount).toString();
    }

    public static HiveColumnStatistics createIntegerColumnStatistics(OptionalLong min, OptionalLong max, OptionalLong nullsCount, OptionalLong distinctValuesCount) {
        return HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(min, max)).setNullsCount(nullsCount).setDistinctValuesCount(distinctValuesCount).build();
    }

    public static HiveColumnStatistics createDoubleColumnStatistics(OptionalDouble min, OptionalDouble max, OptionalLong nullsCount, OptionalLong distinctValuesCount) {
        return HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(min, max)).setNullsCount(nullsCount).setDistinctValuesCount(distinctValuesCount).build();
    }

    public static HiveColumnStatistics createDecimalColumnStatistics(Optional<BigDecimal> min, Optional<BigDecimal> max, OptionalLong nullsCount, OptionalLong distinctValuesCount) {
        return HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(min, max)).setNullsCount(nullsCount).setDistinctValuesCount(distinctValuesCount).build();
    }

    public static HiveColumnStatistics createDateColumnStatistics(Optional<LocalDate> min, Optional<LocalDate> max, OptionalLong nullsCount, OptionalLong distinctValuesCount) {
        return HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(min, max)).setNullsCount(nullsCount).setDistinctValuesCount(distinctValuesCount).build();
    }

    public static HiveColumnStatistics createBooleanColumnStatistics(OptionalLong trueCount, OptionalLong falseCount, OptionalLong nullsCount) {
        return HiveColumnStatistics.builder().setBooleanStatistics(new BooleanStatistics(trueCount, falseCount)).setNullsCount(nullsCount).build();
    }

    public static HiveColumnStatistics createStringColumnStatistics(OptionalLong maxValueSizeInBytes, OptionalLong totalSizeInBytes, OptionalLong nullsCount, OptionalLong distinctValuesCount) {
        return HiveColumnStatistics.builder().setMaxValueSizeInBytes(maxValueSizeInBytes).setTotalSizeInBytes(totalSizeInBytes).setNullsCount(nullsCount).setDistinctValuesCount(distinctValuesCount).build();
    }

    public static HiveColumnStatistics createBinaryColumnStatistics(OptionalLong maxValueSizeInBytes, OptionalLong totalSizeInBytes, OptionalLong nullsCount) {
        return HiveColumnStatistics.builder().setMaxValueSizeInBytes(maxValueSizeInBytes).setTotalSizeInBytes(totalSizeInBytes).setNullsCount(nullsCount).build();
    }

    public static Builder builder(HiveColumnStatistics other) {
        return new Builder(other);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<IntegerStatistics> integerStatistics = Optional.empty();
        private Optional<DoubleStatistics> doubleStatistics = Optional.empty();
        private Optional<DecimalStatistics> decimalStatistics = Optional.empty();
        private Optional<DateStatistics> dateStatistics = Optional.empty();
        private Optional<BooleanStatistics> booleanStatistics = Optional.empty();
        private OptionalLong maxValueSizeInBytes = OptionalLong.empty();
        private OptionalLong totalSizeInBytes = OptionalLong.empty();
        private OptionalLong nullsCount = OptionalLong.empty();
        private OptionalLong distinctValuesCount = OptionalLong.empty();

        private Builder() {
        }

        private Builder(HiveColumnStatistics other) {
            this.integerStatistics = other.getIntegerStatistics();
            this.doubleStatistics = other.getDoubleStatistics();
            this.decimalStatistics = other.getDecimalStatistics();
            this.dateStatistics = other.getDateStatistics();
            this.booleanStatistics = other.getBooleanStatistics();
            this.maxValueSizeInBytes = other.getMaxValueSizeInBytes();
            this.totalSizeInBytes = other.getTotalSizeInBytes();
            this.nullsCount = other.getNullsCount();
            this.distinctValuesCount = other.getDistinctValuesCount();
        }

        public Builder setIntegerStatistics(Optional<IntegerStatistics> integerStatistics) {
            this.integerStatistics = integerStatistics;
            return this;
        }

        public Builder setIntegerStatistics(IntegerStatistics integerStatistics) {
            this.integerStatistics = Optional.of(integerStatistics);
            return this;
        }

        public Builder setDoubleStatistics(Optional<DoubleStatistics> doubleStatistics) {
            this.doubleStatistics = doubleStatistics;
            return this;
        }

        public Builder setDoubleStatistics(DoubleStatistics doubleStatistics) {
            this.doubleStatistics = Optional.of(doubleStatistics);
            return this;
        }

        public Builder setDecimalStatistics(Optional<DecimalStatistics> decimalStatistics) {
            this.decimalStatistics = decimalStatistics;
            return this;
        }

        public Builder setDecimalStatistics(DecimalStatistics decimalStatistics) {
            this.decimalStatistics = Optional.of(decimalStatistics);
            return this;
        }

        public Builder setDateStatistics(Optional<DateStatistics> dateStatistics) {
            this.dateStatistics = dateStatistics;
            return this;
        }

        public Builder setDateStatistics(DateStatistics dateStatistics) {
            this.dateStatistics = Optional.of(dateStatistics);
            return this;
        }

        public Builder setBooleanStatistics(Optional<BooleanStatistics> booleanStatistics) {
            this.booleanStatistics = booleanStatistics;
            return this;
        }

        public Builder setBooleanStatistics(BooleanStatistics booleanStatistics) {
            this.booleanStatistics = Optional.of(booleanStatistics);
            return this;
        }

        public Builder setMaxValueSizeInBytes(long maxValueSizeInBytes) {
            this.maxValueSizeInBytes = OptionalLong.of(maxValueSizeInBytes);
            return this;
        }

        public Builder setMaxValueSizeInBytes(OptionalLong maxValueSizeInBytes) {
            this.maxValueSizeInBytes = maxValueSizeInBytes;
            return this;
        }

        public Builder setTotalSizeInBytes(long totalSizeInBytes) {
            this.totalSizeInBytes = OptionalLong.of(totalSizeInBytes);
            return this;
        }

        public Builder setTotalSizeInBytes(OptionalLong totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        public Builder setNullsCount(OptionalLong nullsCount) {
            this.nullsCount = nullsCount;
            return this;
        }

        public Builder setNullsCount(long nullsCount) {
            this.nullsCount = OptionalLong.of(nullsCount);
            return this;
        }

        public Builder setDistinctValuesCount(OptionalLong distinctValuesCount) {
            this.distinctValuesCount = distinctValuesCount;
            return this;
        }

        public Builder setDistinctValuesCount(long distinctValuesCount) {
            this.distinctValuesCount = OptionalLong.of(distinctValuesCount);
            return this;
        }

        public HiveColumnStatistics build() {
            return new HiveColumnStatistics(this.integerStatistics, this.doubleStatistics, this.decimalStatistics, this.dateStatistics, this.booleanStatistics, this.maxValueSizeInBytes, this.totalSizeInBytes, this.nullsCount, this.distinctValuesCount);
        }
    }
}

