/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.fs.MonitoredInput;
import io.trino.plugin.hive.fs.MonitoredInputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;

public final class MonitoredInputFile
implements TrinoInputFile {
    private final FileFormatDataSourceStats stats;
    private final TrinoInputFile delegate;

    public MonitoredInputFile(FileFormatDataSourceStats stats, TrinoInputFile delegate) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    public TrinoInput newInput() throws IOException {
        return new MonitoredInput(this.stats, this.delegate.newInput());
    }

    public TrinoInputStream newStream() throws IOException {
        return new MonitoredInputStream(this.stats, this.delegate.newStream());
    }

    public long length() throws IOException {
        return this.delegate.length();
    }

    public Instant lastModified() throws IOException {
        return this.delegate.lastModified();
    }

    public boolean exists() throws IOException {
        return this.delegate.exists();
    }

    public Location location() {
        return this.delegate.location();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

