/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.annotation.NotThreadSafe;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.spi.HostAddress;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.function.BooleanSupplier;

@NotThreadSafe
public class InternalHiveSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(InternalHiveSplit.class) + SizeOf.instanceSize(Properties.class) + SizeOf.instanceSize(OptionalInt.class);
    private final String path;
    private final long end;
    private final long estimatedFileSize;
    private final long fileModifiedTime;
    private final Properties schema;
    private final List<HivePartitionKey> partitionKeys;
    private final List<InternalHiveBlock> blocks;
    private final String partitionName;
    private final OptionalInt readBucketNumber;
    private final OptionalInt tableBucketNumber;
    private final boolean splittable;
    private final boolean forceLocalScheduling;
    private final TableToPartitionMapping tableToPartitionMapping;
    private final Optional<HiveSplit.BucketConversion> bucketConversion;
    private final Optional<HiveSplit.BucketValidation> bucketValidation;
    private final boolean s3SelectPushdownEnabled;
    private final Optional<AcidInfo> acidInfo;
    private final BooleanSupplier partitionMatchSupplier;
    private long start;
    private int currentBlockIndex;

    public InternalHiveSplit(String partitionName, String path, long start, long end, long estimatedFileSize, long fileModifiedTime, Properties schema, List<HivePartitionKey> partitionKeys, List<InternalHiveBlock> blocks, OptionalInt readBucketNumber, OptionalInt tableBucketNumber, boolean splittable, boolean forceLocalScheduling, TableToPartitionMapping tableToPartitionMapping, Optional<HiveSplit.BucketConversion> bucketConversion, Optional<HiveSplit.BucketValidation> bucketValidation, boolean s3SelectPushdownEnabled, Optional<AcidInfo> acidInfo, BooleanSupplier partitionMatchSupplier) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start must be positive");
        Preconditions.checkArgument((end >= 0L ? 1 : 0) != 0, (Object)"length must be positive");
        Preconditions.checkArgument((estimatedFileSize >= 0L ? 1 : 0) != 0, (Object)"fileSize must be positive");
        Objects.requireNonNull(partitionName, "partitionName is null");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(blocks, "blocks is null");
        Objects.requireNonNull(readBucketNumber, "readBucketNumber is null");
        Objects.requireNonNull(tableBucketNumber, "tableBucketNumber is null");
        Objects.requireNonNull(tableToPartitionMapping, "tableToPartitionMapping is null");
        Objects.requireNonNull(bucketConversion, "bucketConversion is null");
        Objects.requireNonNull(bucketValidation, "bucketValidation is null");
        Objects.requireNonNull(acidInfo, "acidInfo is null");
        Objects.requireNonNull(partitionMatchSupplier, "partitionMatchSupplier is null");
        this.partitionName = partitionName;
        this.path = path;
        this.start = start;
        this.end = end;
        this.estimatedFileSize = estimatedFileSize;
        this.fileModifiedTime = fileModifiedTime;
        this.schema = schema;
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.blocks = ImmutableList.copyOf(blocks);
        this.readBucketNumber = readBucketNumber;
        this.tableBucketNumber = tableBucketNumber;
        this.splittable = splittable;
        this.forceLocalScheduling = forceLocalScheduling;
        this.tableToPartitionMapping = tableToPartitionMapping;
        this.bucketConversion = bucketConversion;
        this.bucketValidation = bucketValidation;
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
        this.acidInfo = acidInfo;
        this.partitionMatchSupplier = partitionMatchSupplier;
    }

    public String getPath() {
        return this.path;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getEstimatedFileSize() {
        return this.estimatedFileSize;
    }

    public long getFileModifiedTime() {
        return this.fileModifiedTime;
    }

    public boolean isS3SelectPushdownEnabled() {
        return this.s3SelectPushdownEnabled;
    }

    public Properties getSchema() {
        return this.schema;
    }

    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public OptionalInt getReadBucketNumber() {
        return this.readBucketNumber;
    }

    public OptionalInt getTableBucketNumber() {
        return this.tableBucketNumber;
    }

    public boolean isSplittable() {
        return this.splittable;
    }

    public boolean isForceLocalScheduling() {
        return this.forceLocalScheduling;
    }

    public TableToPartitionMapping getTableToPartitionMapping() {
        return this.tableToPartitionMapping;
    }

    public Optional<HiveSplit.BucketConversion> getBucketConversion() {
        return this.bucketConversion;
    }

    public Optional<HiveSplit.BucketValidation> getBucketValidation() {
        return this.bucketValidation;
    }

    public InternalHiveBlock currentBlock() {
        Preconditions.checkState((!this.isDone() ? 1 : 0) != 0, (Object)"All blocks have been consumed");
        return this.blocks.get(this.currentBlockIndex);
    }

    public boolean isDone() {
        return this.currentBlockIndex == this.blocks.size();
    }

    public void increaseStart(long value) {
        this.start += value;
        if (this.start == this.currentBlock().getEnd()) {
            ++this.currentBlockIndex;
            if (this.isDone()) {
                return;
            }
            Verify.verify((this.start == this.currentBlock().getStart() ? 1 : 0) != 0);
        }
    }

    public int getEstimatedSizeInBytes() {
        long result = (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + SizeOf.estimatedSizeOf(this.partitionKeys, HivePartitionKey::getEstimatedSizeInBytes) + SizeOf.estimatedSizeOf(this.blocks, InternalHiveBlock::getEstimatedSizeInBytes) + SizeOf.estimatedSizeOf((String)this.partitionName) + (long)this.tableToPartitionMapping.getEstimatedSizeInBytes();
        return Math.toIntExact(result);
    }

    public Optional<AcidInfo> getAcidInfo() {
        return this.acidInfo;
    }

    public BooleanSupplier getPartitionMatchSupplier() {
        return this.partitionMatchSupplier;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("start", this.start).add("end", this.end).add("estimatedFileSize", this.estimatedFileSize).toString();
    }

    public static class InternalHiveBlock {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(InternalHiveBlock.class);
        private static final int HOST_ADDRESS_INSTANCE_SIZE = SizeOf.instanceSize(HostAddress.class);
        private final long start;
        private final long end;
        private final List<HostAddress> addresses;

        public InternalHiveBlock(long start, long end, List<HostAddress> addresses) {
            Preconditions.checkArgument((start <= end ? 1 : 0) != 0, (Object)"block end cannot be before block start");
            this.start = start;
            this.end = end;
            this.addresses = ImmutableList.copyOf(addresses);
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public List<HostAddress> getAddresses() {
            return this.addresses;
        }

        public long getEstimatedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.addresses, address -> (long)HOST_ADDRESS_INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)address.getHostText()));
        }
    }
}

