/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.AcidTables;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.Path;

public class HiveLocationService
implements LocationService {
    private final HdfsEnvironment hdfsEnvironment;
    private final boolean temporaryStagingDirectoryEnabled;
    private final String temporaryStagingDirectoryPath;

    @Inject
    public HiveLocationService(HdfsEnvironment hdfsEnvironment, HiveConfig hiveConfig) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.temporaryStagingDirectoryEnabled = hiveConfig.isTemporaryStagingDirectoryEnabled();
        this.temporaryStagingDirectoryPath = hiveConfig.getTemporaryStagingDirectoryPath();
    }

    @Override
    public Location forNewTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, String schemaName, String tableName) {
        HdfsContext context = new HdfsContext(session);
        Location targetPath = HiveWriteUtils.getTableDefaultLocation(context, metastore, this.hdfsEnvironment, schemaName, tableName);
        if (HiveWriteUtils.pathExists(context, this.hdfsEnvironment, new Path(targetPath.toString()))) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s.%s' already exists: %s", schemaName, tableName, targetPath));
        }
        return targetPath;
    }

    @Override
    public LocationHandle forNewTableAsSelect(SemiTransactionalHiveMetastore metastore, ConnectorSession session, String schemaName, String tableName, Optional<Location> externalLocation) {
        HdfsContext context = new HdfsContext(session);
        Location targetPath = externalLocation.orElseGet(() -> HiveWriteUtils.getTableDefaultLocation(context, metastore, this.hdfsEnvironment, schemaName, tableName));
        if (HiveWriteUtils.pathExists(context, this.hdfsEnvironment, new Path(targetPath.toString()))) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s.%s' already exists: %s", schemaName, tableName, targetPath));
        }
        if (this.shouldUseTemporaryDirectory(context, new Path(targetPath.toString()), externalLocation.isPresent())) {
            Location writePath = HiveWriteUtils.createTemporaryPath(context, this.hdfsEnvironment, new Path(targetPath.toString()), this.temporaryStagingDirectoryPath);
            return new LocationHandle(targetPath, writePath, LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY);
        }
        return new LocationHandle(targetPath, targetPath, LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY);
    }

    @Override
    public LocationHandle forExistingTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table) {
        HdfsContext context = new HdfsContext(session);
        Location targetPath = Location.of((String)table.getStorage().getLocation());
        if (this.shouldUseTemporaryDirectory(context, new Path(targetPath.toString()), false) && !AcidTables.isTransactionalTable(table.getParameters())) {
            Location writePath = HiveWriteUtils.createTemporaryPath(context, this.hdfsEnvironment, new Path(targetPath.toString()), this.temporaryStagingDirectoryPath);
            return new LocationHandle(targetPath, writePath, LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY);
        }
        return new LocationHandle(targetPath, targetPath, LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY);
    }

    @Override
    public LocationHandle forOptimize(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table) {
        Location targetPath = Location.of((String)table.getStorage().getLocation());
        return new LocationHandle(targetPath, targetPath, LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY);
    }

    private boolean shouldUseTemporaryDirectory(HdfsContext context, Path path, boolean hasExternalLocation) {
        return this.temporaryStagingDirectoryEnabled && !HiveWriteUtils.isS3FileSystem(context, this.hdfsEnvironment, path) && !HiveWriteUtils.isHdfsEncrypted(context, this.hdfsEnvironment, path) && !hasExternalLocation;
    }

    @Override
    public LocationService.WriteInfo getQueryWriteInfo(LocationHandle locationHandle) {
        return new LocationService.WriteInfo(locationHandle.getTargetPath(), locationHandle.getWritePath(), locationHandle.getWriteMode());
    }

    @Override
    public LocationService.WriteInfo getTableWriteInfo(LocationHandle locationHandle, boolean overwrite) {
        if (overwrite && locationHandle.getWriteMode() != LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Overwriting unpartitioned table not supported when writing directly to target directory");
        }
        return new LocationService.WriteInfo(locationHandle.getTargetPath(), locationHandle.getWritePath(), locationHandle.getWriteMode());
    }

    @Override
    public LocationService.WriteInfo getPartitionWriteInfo(LocationHandle locationHandle, Optional<Partition> partition, String partitionName) {
        if (partition.isPresent()) {
            LocationHandle.WriteMode writeMode = locationHandle.getWriteMode();
            Location targetPath = Location.of((String)partition.get().getStorage().getLocation());
            Location writePath = HiveLocationService.getPartitionWritePath(locationHandle, partitionName, writeMode, targetPath);
            return new LocationService.WriteInfo(targetPath, writePath, writeMode);
        }
        return new LocationService.WriteInfo(locationHandle.getTargetPath().appendPath(partitionName), locationHandle.getWritePath().appendPath(partitionName), locationHandle.getWriteMode());
    }

    private static Location getPartitionWritePath(LocationHandle locationHandle, String partitionName, LocationHandle.WriteMode writeMode, Location targetPath) {
        return switch (writeMode) {
            default -> throw new IncompatibleClassChangeError();
            case LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY -> locationHandle.getWritePath().appendPath(partitionName);
            case LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY -> targetPath;
            case LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY -> throw new UnsupportedOperationException(String.format("inserting into existing partition is not supported for %s", new Object[]{writeMode}));
        };
    }
}

