/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.contrib.awsxray.propagator.AwsXrayPropagator;
import java.util.Collections;
import java.util.Map;

final class SqsParentContext {
    static final String AWS_TRACE_SYSTEM_ATTRIBUTE = "AWSTraceHeader";

    static Context ofSystemAttributes(Map<String, String> systemAttributes) {
        String traceHeader = systemAttributes.get(AWS_TRACE_SYSTEM_ATTRIBUTE);
        return AwsXrayPropagator.getInstance().extract(Context.root(), Collections.singletonMap("X-Amzn-Trace-Id", traceHeader), (TextMapGetter)MapGetter.INSTANCE);
    }

    private SqsParentContext() {
    }

    static enum MapGetter implements TextMapGetter<Map<String, String>>
    {
        INSTANCE;


        public Iterable<String> keys(Map<String, String> map) {
            return map.keySet();
        }

        public String get(Map<String, String> map, String s) {
            return map.get(s);
        }
    }
}

