/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.thrift;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.thrift.ColumnBuffer;
import org.apache.hadoop.hive.serde2.thrift.ThriftFormatter;
import org.apache.hadoop.hive.serde2.thrift.Type;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ThriftJDBCBinarySerDe
extends AbstractSerDe {
    public static final Logger LOG = LoggerFactory.getLogger(ThriftJDBCBinarySerDe.class.getName());
    private List<String> columnNames;
    private List<TypeInfo> columnTypes;
    private ColumnBuffer[] columnBuffers;
    private TypeInfo rowTypeInfo;
    private ArrayList<Object> row;
    private BytesWritable serializedBytesWritable = new BytesWritable();
    private ByteStream.Output output = new ByteStream.Output();
    private TProtocol protocol = new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)this.output));
    private ThriftFormatter thriftFormatter = new ThriftFormatter();
    private int MAX_BUFFERED_ROWS;
    private int count;
    private StructObjectInspector rowObjectInspector;

    @Override
    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        this.MAX_BUFFERED_ROWS = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_DEFAULT_FETCH_SIZE);
        LOG.info("ThriftJDBCBinarySerDe max number of buffered columns: " + this.MAX_BUFFERED_ROWS);
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        String columnNameDelimiter = tbl.containsKey("column.name.delimiter") ? tbl.getProperty("column.name.delimiter") : String.valueOf(',');
        this.columnNames = columnNameProperty.length() == 0 ? new ArrayList<String>() : Arrays.asList(columnNameProperty.split(columnNameDelimiter));
        this.columnTypes = columnTypeProperty.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        this.rowTypeInfo = TypeInfoFactory.getStructTypeInfo(this.columnNames, this.columnTypes);
        this.rowObjectInspector = (StructObjectInspector)TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(this.rowTypeInfo);
        this.initializeRowAndColumns();
        try {
            this.thriftFormatter.initialize(conf, tbl);
        }
        catch (Exception e) {
            throw new SerDeException(e);
        }
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return BytesWritable.class;
    }

    private Writable serializeBatch() throws SerDeException {
        this.output.reset();
        for (int i = 0; i < this.columnBuffers.length; ++i) {
            TColumn tColumn = this.columnBuffers[i].toTColumn();
            try {
                tColumn.write(this.protocol);
                continue;
            }
            catch (TException e) {
                throw new SerDeException(e);
            }
        }
        this.initializeRowAndColumns();
        this.serializedBytesWritable.set(this.output.getData(), 0, this.output.getLength());
        return this.serializedBytesWritable;
    }

    private void initializeRowAndColumns() {
        int i;
        this.row = new ArrayList(this.columnNames.size());
        for (i = 0; i < this.columnNames.size(); ++i) {
            this.row.add(null);
        }
        this.columnBuffers = new ColumnBuffer[this.columnNames.size()];
        for (i = 0; i < this.columnBuffers.length; ++i) {
            this.columnBuffers[i] = new ColumnBuffer(Type.getType(this.columnTypes.get(i)));
        }
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (obj == null) {
            return this.serializeBatch();
        }
        ++this.count;
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        try {
            Object[] formattedRow = (Object[])this.thriftFormatter.convert(obj, objInspector);
            for (int i = 0; i < this.columnNames.size(); ++i) {
                this.columnBuffers[i].addValue(formattedRow[i]);
            }
        }
        catch (Exception e) {
            throw new SerDeException(e);
        }
        if (this.count == this.MAX_BUFFERED_ROWS) {
            this.count = 0;
            return this.serializeBatch();
        }
        return null;
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }

    @Override
    public Object deserialize(Writable blob) throws SerDeException {
        return ((BytesWritable)blob).getBytes();
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowObjectInspector;
    }
}

