/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.DynamicValueRegistry;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.parse.RuntimeValuesInfo;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class DynamicValueRegistryTez
implements DynamicValueRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicValueRegistryTez.class);
    static final NullValue NULL_VALUE = new NullValue();
    protected Map<String, Object> values = new ConcurrentHashMap<String, Object>();

    @Override
    public Object getValue(String key) {
        if (!this.values.containsKey(key)) {
            throw new DynamicValue.NoDynamicValuesException("Value does not exist in registry: " + key);
        }
        Object val = this.values.get(key);
        if (val == NULL_VALUE) {
            return null;
        }
        return val;
    }

    protected void setValue(String key, Object value) {
        if (value == null) {
            this.values.put(key, NULL_VALUE);
        } else {
            this.values.put(key, value);
        }
    }

    @Override
    public void init(DynamicValueRegistry.RegistryConf conf) throws Exception {
        RegistryConfTez rct = (RegistryConfTez)conf;
        for (String inputSourceName : rct.baseWork.getInputSourceToRuntimeValuesInfo().keySet()) {
            LOG.info("Runtime value source: " + inputSourceName);
            LogicalInput runtimeValueInput = rct.inputs.get(inputSourceName);
            RuntimeValuesInfo runtimeValuesInfo = rct.baseWork.getInputSourceToRuntimeValuesInfo().get(inputSourceName);
            Deserializer deserializer = (Deserializer)ReflectionUtils.newInstance(runtimeValuesInfo.getTableDesc().getDeserializerClass(), null);
            deserializer.initialize(rct.conf, runtimeValuesInfo.getTableDesc().getProperties());
            ObjectInspector inspector = deserializer.getObjectInspector();
            ArrayList<ExprNodeEvaluator> colExprEvaluators = new ArrayList<ExprNodeEvaluator>();
            for (ExprNodeDesc expr : runtimeValuesInfo.getColExprs()) {
                ExprNodeEvaluator exprEval = ExprNodeEvaluatorFactory.get(expr, null);
                exprEval.initialize(inspector);
                colExprEvaluators.add(exprEval);
            }
            runtimeValueInput.start();
            ArrayList<LogicalInput> inputList = new ArrayList<LogicalInput>();
            inputList.add(runtimeValueInput);
            rct.processorContext.waitForAllInputsReady(inputList);
            KeyValueReader kvReader = (KeyValueReader)runtimeValueInput.getReader();
            long rowCount = 0L;
            while (kvReader.next()) {
                Object row = deserializer.deserialize((Writable)kvReader.getCurrentValue());
                ++rowCount;
                for (int colIdx = 0; colIdx < colExprEvaluators.size(); ++colIdx) {
                    ExprNodeEvaluator eval = (ExprNodeEvaluator)colExprEvaluators.get(colIdx);
                    Object val = eval.evaluate(row);
                    this.setValue(runtimeValuesInfo.getDynamicValueIDs().get(colIdx), val);
                }
            }
            if (rowCount == 0L) {
                LOG.debug("No input rows from " + inputSourceName + ", filling dynamic values with nulls");
                for (int colIdx = 0; colIdx < colExprEvaluators.size(); ++colIdx) {
                    ExprNodeEvaluator eval = (ExprNodeEvaluator)colExprEvaluators.get(colIdx);
                    this.setValue(runtimeValuesInfo.getDynamicValueIDs().get(colIdx), null);
                }
                continue;
            }
            if (rowCount <= 1L) continue;
            throw new IllegalStateException("Expected 0 or 1 rows from " + inputSourceName + ", got " + rowCount);
        }
    }

    static class NullValue {
        NullValue() {
        }
    }

    public static class RegistryConfTez
    extends DynamicValueRegistry.RegistryConf {
        public Configuration conf;
        public BaseWork baseWork;
        public ProcessorContext processorContext;
        public Map<String, LogicalInput> inputs;

        public RegistryConfTez(Configuration conf, BaseWork baseWork, ProcessorContext processorContext, Map<String, LogicalInput> inputs) {
            this.conf = conf;
            this.baseWork = baseWork;
            this.processorContext = processorContext;
            this.inputs = inputs;
        }
    }
}

