/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.datasource;

import io.trino.hive.$internal.com.google.common.collect.ImmutableList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.datasource.BoneCPDataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.HikariCPDataSourceProvider;

public abstract class DataSourceProviderFactory {
    private static final ImmutableList<DataSourceProvider> FACTORIES = ((ImmutableList.Builder)ImmutableList.builder().add(new DataSourceProvider[]{new HikariCPDataSourceProvider(), new BoneCPDataSourceProvider()})).build();

    public static DataSourceProvider getDataSourceProvider(Configuration hdpConfig) {
        for (DataSourceProvider factory : FACTORIES) {
            if (!factory.supports(hdpConfig)) continue;
            return factory;
        }
        return null;
    }
}

