/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.orc.impl;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import io.trino.hive.orc.Reader;
import io.trino.hive.orc.TypeDescription;
import io.trino.hive.orc.impl.ConvertTreeReaderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;

public class SchemaEvolution {
    private final TypeDescription[] readerFileTypes;
    private final boolean[] readerIncluded;
    private final int readerColumnOffset;
    private final boolean[] fileIncluded;
    private final TypeDescription fileSchema;
    private final TypeDescription readerSchema;
    private boolean hasConversion = false;
    private final boolean isAcid;
    private final boolean isSchemaEvolutionCaseAware;
    private final boolean[] ppdSafeConversion;
    private static final Logger LOG = LoggerFactory.getLogger(SchemaEvolution.class);
    private static final Pattern missingMetadataPattern = Pattern.compile("_col\\d+");
    private static final List<String> acidEventFieldNames = new ArrayList<String>();

    public SchemaEvolution(TypeDescription fileSchema, TypeDescription readerSchema, Reader.Options options) {
        boolean allowMissingMetadata = options.getTolerateMissingSchema();
        boolean[] includedCols = options.getInclude();
        this.isSchemaEvolutionCaseAware = options.getIsSchemaEvolutionCaseAware();
        this.readerIncluded = includedCols == null ? null : Arrays.copyOf(includedCols, includedCols.length);
        this.fileIncluded = new boolean[fileSchema.getMaximumId() + 1];
        this.hasConversion = false;
        this.fileSchema = fileSchema;
        this.isAcid = SchemaEvolution.checkAcidSchema(fileSchema);
        int n = this.readerColumnOffset = this.isAcid ? acidEventFieldNames.size() : 0;
        if (readerSchema != null) {
            this.readerSchema = this.isAcid ? SchemaEvolution.createEventSchema(readerSchema) : readerSchema;
            if (this.readerIncluded != null && this.readerIncluded.length + this.readerColumnOffset != this.readerSchema.getMaximumId() + 1) {
                throw new IllegalArgumentException("Include vector the wrong length: " + this.readerSchema.toJson() + " with include length " + this.readerIncluded.length);
            }
            this.readerFileTypes = new TypeDescription[this.readerSchema.getMaximumId() + 1];
            int positionalLevels = 0;
            if (options.getForcePositionalEvolution()) {
                positionalLevels = this.isAcid ? 2 : 1;
                this.buildConversion(fileSchema, this.readerSchema, positionalLevels);
            } else if (!this.hasColumnNames(this.isAcid ? SchemaEvolution.getBaseRow(fileSchema) : fileSchema) && !this.fileSchema.equals(this.readerSchema)) {
                if (!allowMissingMetadata) {
                    throw new RuntimeException("Found that schema metadata is missing from file. This is likely caused by a writer earlier than HIVE-4243. Will not try to reconcile schemas");
                }
                LOG.warn("Column names are missing from this file. This is caused by a writer earlier than HIVE-4243. The reader will reconcile schemas based on index. File type: " + this.fileSchema + ", reader type: " + this.readerSchema);
                positionalLevels = this.isAcid ? 2 : 1;
            }
            this.buildConversion(fileSchema, this.readerSchema, positionalLevels);
        } else {
            this.readerSchema = fileSchema;
            this.readerFileTypes = new TypeDescription[this.readerSchema.getMaximumId() + 1];
            if (this.readerIncluded != null && this.readerIncluded.length + this.readerColumnOffset != this.readerSchema.getMaximumId() + 1) {
                throw new IllegalArgumentException("Include vector the wrong length: " + this.readerSchema.toJson() + " with include length " + this.readerIncluded.length);
            }
            this.buildIdentityConversion(this.readerSchema);
        }
        this.ppdSafeConversion = this.populatePpdSafeConversion();
    }

    @Deprecated
    public SchemaEvolution(TypeDescription fileSchema, boolean[] readerIncluded) {
        this(fileSchema, null, readerIncluded);
    }

    @Deprecated
    public SchemaEvolution(TypeDescription fileSchema, TypeDescription readerSchema, boolean[] readerIncluded) {
        this(fileSchema, readerSchema, new Reader.Options(new Configuration()).include(readerIncluded));
    }

    private boolean hasColumnNames(TypeDescription fileSchema) {
        if (fileSchema.getCategory() != TypeDescription.Category.STRUCT) {
            return true;
        }
        for (String fieldName : fileSchema.getFieldNames()) {
            if (missingMetadataPattern.matcher(fieldName).matches()) continue;
            return true;
        }
        return false;
    }

    public TypeDescription getReaderSchema() {
        return this.readerSchema;
    }

    public TypeDescription getReaderBaseSchema() {
        return this.isAcid ? SchemaEvolution.getBaseRow(this.readerSchema) : this.readerSchema;
    }

    boolean isAcid() {
        return this.isAcid;
    }

    public boolean hasConversion() {
        return this.hasConversion;
    }

    public TypeDescription getFileSchema() {
        return this.fileSchema;
    }

    public TypeDescription getFileType(TypeDescription readerType) {
        return this.getFileType(readerType.getId());
    }

    public TypeDescription getFileType(int id) {
        return this.readerFileTypes[id];
    }

    public boolean[] getReaderIncluded() {
        return this.readerIncluded;
    }

    public boolean[] getFileIncluded() {
        return this.fileIncluded;
    }

    public boolean isPPDSafeConversion(int colId) {
        if (this.hasConversion()) {
            return colId >= 0 && colId < this.ppdSafeConversion.length && this.ppdSafeConversion[colId];
        }
        return true;
    }

    private boolean[] populatePpdSafeConversion() {
        boolean safePpd;
        if (this.fileSchema == null || this.readerSchema == null || this.readerFileTypes == null) {
            return null;
        }
        boolean[] result = new boolean[this.readerSchema.getMaximumId() + 1];
        result[this.readerSchema.getId()] = safePpd = this.validatePPDConversion(this.fileSchema, this.readerSchema);
        return this.populatePpdSafeConversionForChildern(result, this.readerSchema.getChildren());
    }

    private boolean[] populatePpdSafeConversionForChildern(boolean[] ppdSafeConversion, List<TypeDescription> children) {
        if (children != null) {
            for (TypeDescription child : children) {
                boolean safePpd;
                TypeDescription fileType = this.getFileType(child.getId());
                ppdSafeConversion[child.getId()] = safePpd = this.validatePPDConversion(fileType, child);
                this.populatePpdSafeConversionForChildern(ppdSafeConversion, child.getChildren());
            }
        }
        return ppdSafeConversion;
    }

    private boolean validatePPDConversion(TypeDescription fileType, TypeDescription readerType) {
        if (fileType == null) {
            return false;
        }
        if (fileType.getCategory().isPrimitive()) {
            if (fileType.getCategory().equals((Object)readerType.getCategory())) {
                return fileType.getCategory() != TypeDescription.Category.DECIMAL || fileType.equals(readerType);
            }
            switch (fileType.getCategory()) {
                case BYTE: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.SHORT) && !readerType.getCategory().equals((Object)TypeDescription.Category.INT) && !readerType.getCategory().equals((Object)TypeDescription.Category.LONG)) break;
                    return true;
                }
                case SHORT: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.INT) && !readerType.getCategory().equals((Object)TypeDescription.Category.LONG)) break;
                    return true;
                }
                case INT: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.LONG)) break;
                    return true;
                }
                case STRING: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.VARCHAR)) break;
                    return true;
                }
                case VARCHAR: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.STRING)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean includeReaderColumn(int readerId) {
        return this.readerIncluded == null || readerId <= this.readerColumnOffset || this.readerIncluded[readerId - this.readerColumnOffset];
    }

    void buildConversion(TypeDescription fileType, TypeDescription readerType, int positionalLevels) {
        boolean isOk;
        block21: {
            block20: {
                if (!this.includeReaderColumn(readerType.getId())) {
                    return;
                }
                isOk = true;
                if (fileType.getCategory() != readerType.getCategory()) break block20;
                switch (readerType.getCategory()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case STRING: 
                    case BOOLEAN: 
                    case LONG: 
                    case DOUBLE: 
                    case FLOAT: 
                    case TIMESTAMP: 
                    case BINARY: 
                    case DATE: {
                        break block21;
                    }
                    case VARCHAR: 
                    case CHAR: {
                        if (fileType.getMaxLength() != readerType.getMaxLength()) {
                            this.hasConversion = true;
                        }
                        break block21;
                    }
                    case DECIMAL: {
                        if (fileType.getPrecision() != readerType.getPrecision() || fileType.getScale() != readerType.getScale()) {
                            this.hasConversion = true;
                        }
                        break block21;
                    }
                    case UNION: 
                    case MAP: 
                    case LIST: {
                        List<TypeDescription> fileChildren = fileType.getChildren();
                        List<TypeDescription> readerChildren = readerType.getChildren();
                        if (fileChildren.size() == readerChildren.size()) {
                            for (int i = 0; i < fileChildren.size(); ++i) {
                                this.buildConversion(fileChildren.get(i), readerChildren.get(i), 0);
                            }
                        } else {
                            isOk = false;
                        }
                        break block21;
                    }
                    case STRUCT: {
                        List<TypeDescription> readerChildren = readerType.getChildren();
                        List<TypeDescription> fileChildren = fileType.getChildren();
                        if (fileChildren.size() != readerChildren.size()) {
                            this.hasConversion = true;
                        }
                        if (positionalLevels == 0) {
                            int i;
                            List<String> readerFieldNames = readerType.getFieldNames();
                            List<String> fileFieldNames = fileType.getFieldNames();
                            HashMap<String, TypeDescription> fileTypesIdx = this.isSchemaEvolutionCaseAware ? new HashMap<String, TypeDescription>() : new CaseInsensitiveMap();
                            for (i = 0; i < fileFieldNames.size(); ++i) {
                                String fileFieldName = fileFieldNames.get(i);
                                fileTypesIdx.put(fileFieldName, fileChildren.get(i));
                            }
                            for (i = 0; i < readerFieldNames.size(); ++i) {
                                String readerFieldName = readerFieldNames.get(i);
                                TypeDescription readerField = readerChildren.get(i);
                                TypeDescription fileField = (TypeDescription)fileTypesIdx.get(readerFieldName);
                                if (fileField == null) continue;
                                this.buildConversion(fileField, readerField, 0);
                            }
                        } else {
                            int jointSize = Math.min(fileChildren.size(), readerChildren.size());
                            for (int i = 0; i < jointSize; ++i) {
                                this.buildConversion(fileChildren.get(i), readerChildren.get(i), positionalLevels - 1);
                            }
                        }
                        break block21;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type " + readerType);
                    }
                }
            }
            isOk = ConvertTreeReaderFactory.canConvert(fileType, readerType);
            this.hasConversion = true;
        }
        if (!isOk) {
            throw new IllegalEvolutionException(String.format("ORC does not support type conversion from file type %s (%d) to reader type %s (%d)", fileType.toString(), fileType.getId(), readerType.toString(), readerType.getId()));
        }
        this.readerFileTypes[readerType.getId()] = fileType;
        this.fileIncluded[fileType.getId()] = true;
    }

    void buildIdentityConversion(TypeDescription readerType) {
        int id = readerType.getId();
        if (!this.includeReaderColumn(id)) {
            return;
        }
        if (this.readerFileTypes[id] != null) {
            throw new RuntimeException("reader to file type entry already assigned");
        }
        this.readerFileTypes[id] = readerType;
        this.fileIncluded[id] = true;
        List<TypeDescription> children = readerType.getChildren();
        if (children != null) {
            for (TypeDescription child : children) {
                this.buildIdentityConversion(child);
            }
        }
    }

    private static boolean checkAcidSchema(TypeDescription type) {
        List<String> rootFields;
        return type.getCategory().equals((Object)TypeDescription.Category.STRUCT) && acidEventFieldNames.equals(rootFields = type.getFieldNames());
    }

    public static TypeDescription createEventSchema(TypeDescription typeDescr) {
        TypeDescription result = TypeDescription.createStruct().addField("operation", TypeDescription.createInt()).addField("originalTransaction", TypeDescription.createLong()).addField("bucket", TypeDescription.createInt()).addField("rowId", TypeDescription.createLong()).addField("currentTransaction", TypeDescription.createLong()).addField("row", typeDescr.clone());
        return result;
    }

    static TypeDescription getBaseRow(TypeDescription typeDescription) {
        int ACID_ROW_OFFSET = 5;
        return typeDescription.getChildren().get(5);
    }

    static {
        acidEventFieldNames.add("operation");
        acidEventFieldNames.add("originalTransaction");
        acidEventFieldNames.add("bucket");
        acidEventFieldNames.add("rowId");
        acidEventFieldNames.add("currentTransaction");
        acidEventFieldNames.add("row");
    }

    private static class CaseInsensitiveMap<V>
    extends HashMap<String, V> {
        private CaseInsensitiveMap() {
        }

        @Override
        public V put(String key, V value) {
            return super.put(key.toLowerCase(), value);
        }

        @Override
        public V get(Object key) {
            return this.get((String)key);
        }

        public V get(String key) {
            return super.get(key.toLowerCase());
        }
    }

    public static class IllegalEvolutionException
    extends RuntimeException {
        public IllegalEvolutionException(String msg) {
            super(msg);
        }
    }
}

