/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.List;

public class PhoenixConfig {
    static final int MAX_ALLOWED_SCANS_PER_SPLIT = 1000;
    private String connectionUrl;
    private List<String> resourceConfigFiles = ImmutableList.of();
    private int maxScansPerSplit = 20;
    private boolean reuseConnection = true;

    @NotNull
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Config(value="phoenix.connection-url")
    public PhoenixConfig setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    public @NotNull List<@FileExists String> getResourceConfigFiles() {
        return this.resourceConfigFiles;
    }

    @Config(value="phoenix.config.resources")
    public PhoenixConfig setResourceConfigFiles(String files) {
        this.resourceConfigFiles = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)files);
        return this;
    }

    @Min(value=1L)
    @Max(value=1000L)
    public @Min(value=1L) @Max(value=1000L) int getMaxScansPerSplit() {
        return this.maxScansPerSplit;
    }

    @Config(value="phoenix.max-scans-per-split")
    @ConfigDescription(value="Maximum number of HBase scans that will be performed in a single split.")
    public PhoenixConfig setMaxScansPerSplit(int scansPerSplit) {
        this.maxScansPerSplit = scansPerSplit;
        return this;
    }

    public boolean isReuseConnection() {
        return this.reuseConnection;
    }

    @Config(value="query.reuse-connection")
    @ConfigDescription(value="Enables reusing JDBC connection within single Trino query to run metadata queries from Coordinator to remote service")
    public PhoenixConfig setReuseConnection(boolean reuseConnection) {
        this.reuseConnection = reuseConnection;
        return this;
    }
}

