/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.Function;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

class ParquetConversions {
    private ParquetConversions() {
    }

    static <T> Literal<T> fromParquetPrimitive(Type type, PrimitiveType parquetType, Object value) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return Literal.of((boolean)((Boolean)value));
            }
            case INTEGER: 
            case DATE: {
                return Literal.of((int)((Integer)value));
            }
            case LONG: 
            case TIME: 
            case TIMESTAMP: {
                return Literal.of((long)((Long)value));
            }
            case FLOAT: {
                return Literal.of((float)((Float)value).floatValue());
            }
            case DOUBLE: {
                return Literal.of((double)((Double)value));
            }
            case STRING: {
                Function<Object, Object> stringConversion = ParquetConversions.converterFromParquet(parquetType);
                return Literal.of((CharSequence)((CharSequence)stringConversion.apply(value)));
            }
            case UUID: {
                Function<Object, Object> uuidConversion = ParquetConversions.converterFromParquet(parquetType);
                return Literal.of((UUID)((UUID)uuidConversion.apply(value)));
            }
            case FIXED: 
            case BINARY: {
                Function<Object, Object> binaryConversion = ParquetConversions.converterFromParquet(parquetType);
                return Literal.of((ByteBuffer)((ByteBuffer)binaryConversion.apply(value)));
            }
            case DECIMAL: {
                Function<Object, Object> decimalConversion = ParquetConversions.converterFromParquet(parquetType);
                return Literal.of((BigDecimal)((BigDecimal)decimalConversion.apply(value)));
            }
        }
        throw new IllegalArgumentException("Unsupported primitive type: " + type);
    }

    static Function<Object, Object> converterFromParquet(PrimitiveType parquetType, Type icebergType) {
        Function<Object, Object> fromParquet = ParquetConversions.converterFromParquet(parquetType);
        if (icebergType != null) {
            if (icebergType.typeId() == Type.TypeID.LONG && parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32) {
                return value -> ((Integer)fromParquet.apply(value)).longValue();
            }
            if (icebergType.typeId() == Type.TypeID.DOUBLE && parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.FLOAT) {
                return value -> ((Float)fromParquet.apply(value)).doubleValue();
            }
        }
        return fromParquet;
    }

    static Function<Object, Object> converterFromParquet(PrimitiveType type) {
        if (type.getOriginalType() != null) {
            switch (type.getOriginalType()) {
                case UTF8: {
                    return binary -> StandardCharsets.UTF_8.decode(((Binary)binary).toByteBuffer());
                }
                case DECIMAL: {
                    LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimal = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)type.getLogicalTypeAnnotation();
                    int scale = decimal.getScale();
                    switch (type.getPrimitiveTypeName()) {
                        case INT32: 
                        case INT64: {
                            return num -> BigDecimal.valueOf(((Number)num).longValue(), scale);
                        }
                        case FIXED_LEN_BYTE_ARRAY: 
                        case BINARY: {
                            return bin -> new BigDecimal(new BigInteger(((Binary)bin).getBytes()), scale);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported primitive type for decimal: " + type.getPrimitiveTypeName());
                }
            }
        }
        switch (type.getPrimitiveTypeName()) {
            case FIXED_LEN_BYTE_ARRAY: 
            case BINARY: {
                return binary -> ByteBuffer.wrap(((Binary)binary).getBytes());
            }
        }
        return obj -> obj;
    }
}

