/*
 * Decompiled with CFR 0.152.
 */
package org.ishugaliy.allgood.consistent.hash.partition;

import java.util.Objects;
import java.util.StringJoiner;
import org.ishugaliy.allgood.consistent.hash.annotation.Generated;
import org.ishugaliy.allgood.consistent.hash.node.Node;
import org.ishugaliy.allgood.consistent.hash.partition.Partition;

public final class ReplicationPartition<T extends Node>
implements Partition<T> {
    private final int index;
    private final T node;
    private long slot;

    public ReplicationPartition(int index, T node) {
        Objects.requireNonNull(node, "Node can not be null");
        this.index = index;
        this.node = node;
    }

    public ReplicationPartition(int index, T node, long slot) {
        this(index, node);
        this.slot = slot;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public T getNode() {
        return this.node;
    }

    @Override
    public long getSlot() {
        return this.slot;
    }

    @Override
    public void setSlot(long slot) {
        this.slot = slot;
    }

    @Override
    public String getPartitionKey() {
        return String.format("rp%d:%s", this.index, this.node.getKey());
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicationPartition)) {
            return false;
        }
        ReplicationPartition that = (ReplicationPartition)o;
        return this.index == that.index && this.slot == that.slot && Objects.equals(this.node, that.node);
    }

    @Generated
    public int hashCode() {
        return Objects.hash(this.index, this.node, this.slot);
    }

    @Generated
    public String toString() {
        return new StringJoiner(", ", ReplicationPartition.class.getSimpleName() + "[", "]").add("index=" + this.index).add("key=" + this.getPartitionKey()).add("slot=" + this.slot).toString();
    }
}

