/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi;

import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.DataTransferClientHelper;
import com.qubole.rubix.spi.fop.ObjectPool;
import com.qubole.rubix.spi.fop.Poolable;
import com.qubole.rubix.spi.fop.SocketChannelObjectFactory;
import java.io.Closeable;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class DataTransferClientFactory {
    private static final AtomicBoolean initFlag = new AtomicBoolean();
    private static ObjectPool pool;
    private static final Log log;

    private DataTransferClientFactory() {
    }

    @VisibleForTesting
    public static void resetConnectionPool() {
        initFlag.set(false);
        pool = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataTransferClient getClient(String host, Configuration conf) {
        if (!initFlag.get()) {
            AtomicBoolean atomicBoolean = initFlag;
            synchronized (atomicBoolean) {
                if (!initFlag.get()) {
                    pool = SocketChannelObjectFactory.createSocketChannelObjectPool(conf, host, CacheConfig.getDataTransferServerPort(conf));
                    initFlag.set(true);
                }
            }
        }
        Poolable<SocketChannel> socketChannelPoolable = pool.borrowObject(host, conf);
        return new DataTransferClient(socketChannelPoolable);
    }

    static {
        log = LogFactory.getLog((String)DataTransferClientHelper.class.getName());
    }

    public static class DataTransferClient
    implements Closeable {
        private Poolable<SocketChannel> socketChannelPoolable;
        private static final Log log = LogFactory.getLog((String)DataTransferClientHelper.class.getName());

        public DataTransferClient(Poolable<SocketChannel> socketChannelPoolable) {
            this.socketChannelPoolable = socketChannelPoolable;
        }

        public SocketChannel getSocketChannel() {
            return this.socketChannelPoolable.getObject();
        }

        @Override
        public void close() {
            log.debug((Object)("Closing socket channel: " + this.socketChannelPoolable.getObject()));
            this.socketChannelPoolable.getPool().returnObject(this.socketChannelPoolable);
        }
    }
}

