/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.util;

import com.google.common.io.Closer;
import io.airlift.slice.XxHash64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SyncingFileOutputStream
extends FileOutputStream {
    private final byte[] oneByte = new byte[1];
    private final XxHash64 hash = new XxHash64();
    private final File file;
    private boolean closed;

    public SyncingFileOutputStream(File file) throws FileNotFoundException {
        super(file);
        this.file = file;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.hash.update(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)b;
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try (Closer closer = Closer.create();){
            closer.register(() -> super.close());
            closer.register(() -> this.getFD().sync());
            closer.register(this::flush);
        }
        try (FileInputStream in = new FileInputStream(this.file);){
            if (this.hash.hash() != XxHash64.hash((InputStream)in)) {
                throw new IOException("File is corrupt after write");
            }
        }
    }
}

