/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.storage;

import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class ShardRecoveryStats {
    private final CounterStat activeShardRecovery = new CounterStat();
    private final CounterStat backgroundShardRecovery = new CounterStat();
    private final CounterStat shardRecoverySuccess = new CounterStat();
    private final CounterStat shardRecoveryFailure = new CounterStat();
    private final CounterStat shardRecoveryBackupNotFound = new CounterStat();
    private final DistributionStat shardRecoveryShardSizeBytes = new DistributionStat();
    private final DistributionStat shardRecoveryTimeInMilliSeconds = new DistributionStat();
    private final DistributionStat shardRecoveryBytesPerSecond = new DistributionStat();
    private final CounterStat corruptLocalFile = new CounterStat();
    private final CounterStat corruptRecoveredFile = new CounterStat();

    public void incrementBackgroundShardRecovery() {
        this.backgroundShardRecovery.update(1L);
    }

    public void incrementActiveShardRecovery() {
        this.activeShardRecovery.update(1L);
    }

    public void incrementShardRecoveryBackupNotFound() {
        this.shardRecoveryBackupNotFound.update(1L);
    }

    public void incrementShardRecoveryFailure() {
        this.shardRecoveryFailure.update(1L);
    }

    public void incrementShardRecoverySuccess() {
        this.shardRecoverySuccess.update(1L);
    }

    public void addShardRecoveryDataRate(DataSize rate, DataSize size, Duration duration) {
        this.shardRecoveryBytesPerSecond.add(rate.toBytes());
        this.shardRecoveryShardSizeBytes.add(size.toBytes());
        this.shardRecoveryTimeInMilliSeconds.add(duration.toMillis());
    }

    public void incrementCorruptLocalFile() {
        this.corruptLocalFile.update(1L);
    }

    public void incrementCorruptRecoveredFile() {
        this.corruptRecoveredFile.update(1L);
    }

    @Managed
    @Nested
    public CounterStat getActiveShardRecovery() {
        return this.activeShardRecovery;
    }

    @Managed
    @Nested
    public CounterStat getBackgroundShardRecovery() {
        return this.backgroundShardRecovery;
    }

    @Managed
    @Nested
    public CounterStat getShardRecoverySuccess() {
        return this.shardRecoverySuccess;
    }

    @Managed
    @Nested
    public CounterStat getShardRecoveryFailure() {
        return this.shardRecoveryFailure;
    }

    @Managed
    @Nested
    public CounterStat getShardRecoveryBackupNotFound() {
        return this.shardRecoveryBackupNotFound;
    }

    @Managed
    @Nested
    public DistributionStat getShardRecoveryBytesPerSecond() {
        return this.shardRecoveryBytesPerSecond;
    }

    @Managed
    @Nested
    public DistributionStat getShardRecoveryTimeInMilliSeconds() {
        return this.shardRecoveryTimeInMilliSeconds;
    }

    @Managed
    @Nested
    public DistributionStat getShardRecoveryShardSizeBytes() {
        return this.shardRecoveryShardSizeBytes;
    }

    @Managed
    @Nested
    public CounterStat getCorruptLocalFile() {
        return this.corruptLocalFile;
    }

    @Managed
    @Nested
    public CounterStat getCorruptRecoveredFile() {
        return this.corruptRecoveredFile;
    }
}

