/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.backup;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.trino.plugin.raptor.legacy.RaptorErrorCode;
import io.trino.plugin.raptor.legacy.backup.BackupStore;
import io.trino.plugin.raptor.legacy.backup.FileBackupConfig;
import io.trino.plugin.raptor.legacy.storage.FileStorageService;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Objects;
import java.util.UUID;

public class FileBackupStore
implements BackupStore {
    private final File baseDir;

    @Inject
    public FileBackupStore(FileBackupConfig config) {
        this(config.getBackupDirectory());
    }

    public FileBackupStore(File baseDir) {
        this.baseDir = Objects.requireNonNull(baseDir, "baseDir is null");
    }

    @PostConstruct
    public void start() {
        FileBackupStore.createDirectories(this.baseDir);
    }

    @Override
    public void backupShard(UUID uuid, File source) {
        File backupFile = this.getBackupFile(uuid);
        try {
            try {
                FileBackupStore.copyFile(source, backupFile);
            }
            catch (FileNotFoundException e) {
                FileBackupStore.createDirectories(backupFile.getParentFile());
                FileBackupStore.copyFile(source, backupFile);
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Failed to create backup shard file", (Throwable)e);
        }
    }

    @Override
    public void restoreShard(UUID uuid, File target) {
        try {
            FileBackupStore.copyFile(this.getBackupFile(uuid), target);
        }
        catch (FileNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_NOT_FOUND, "Backup shard not found: " + uuid, (Throwable)e);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Failed to copy backup shard: " + uuid, (Throwable)e);
        }
    }

    @Override
    public boolean deleteShard(UUID uuid) {
        try {
            return Files.deleteIfExists(this.getBackupFile(uuid).toPath());
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Failed to delete backup shard: " + uuid, (Throwable)e);
        }
    }

    @Override
    public boolean shardExists(UUID uuid) {
        return this.getBackupFile(uuid).isFile();
    }

    @VisibleForTesting
    public File getBackupFile(UUID uuid) {
        return FileStorageService.getFileSystemPath(this.baseDir, uuid);
    }

    private static void createDirectories(File dir) {
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Failed creating directories: " + dir);
        }
    }

    private static void copyFile(File source, File target) throws IOException {
        try (FileInputStream in = new FileInputStream(source);
             FileOutputStream out = new FileOutputStream(target);){
            int n;
            byte[] buffer = new byte[131072];
            while ((n = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
            out.flush();
            out.getFD().sync();
        }
    }
}

