/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy;

import com.google.inject.Inject;
import io.trino.orc.OrcReaderOptions;
import io.trino.plugin.raptor.legacy.RaptorColumnHandle;
import io.trino.plugin.raptor.legacy.RaptorSessionProperties;
import io.trino.plugin.raptor.legacy.RaptorSplit;
import io.trino.plugin.raptor.legacy.RaptorTableHandle;
import io.trino.plugin.raptor.legacy.storage.StorageManager;
import io.trino.plugin.raptor.legacy.util.ConcatPageSource;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.stream.Collectors;

public class RaptorPageSourceProvider
implements ConnectorPageSourceProvider {
    private final StorageManager storageManager;

    @Inject
    public RaptorPageSourceProvider(StorageManager storageManager) {
        this.storageManager = Objects.requireNonNull(storageManager, "storageManager is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        RaptorSplit raptorSplit = (RaptorSplit)split;
        RaptorTableHandle raptorTable = (RaptorTableHandle)table;
        OptionalInt bucketNumber = raptorSplit.getBucketNumber();
        TupleDomain<RaptorColumnHandle> predicate = raptorTable.getConstraint();
        OrcReaderOptions options = new OrcReaderOptions().withMaxMergeDistance(RaptorSessionProperties.getReaderMaxMergeDistance(session)).withMaxBufferSize(RaptorSessionProperties.getReaderMaxReadSize(session)).withStreamBufferSize(RaptorSessionProperties.getReaderStreamBufferSize(session)).withTinyStripeThreshold(RaptorSessionProperties.getReaderTinyStripeThreshold(session)).withLazyReadSmallRanges(RaptorSessionProperties.isReaderLazyReadSmallRanges(session));
        if (raptorSplit.getShardUuids().size() == 1) {
            UUID shardUuid2 = raptorSplit.getShardUuids().iterator().next();
            return this.createPageSource(shardUuid2, bucketNumber, columns, predicate, options);
        }
        Iterator<ConnectorPageSource> iterator = raptorSplit.getShardUuids().stream().map(shardUuid -> this.createPageSource((UUID)shardUuid, bucketNumber, columns, predicate, options)).iterator();
        return new ConcatPageSource(iterator);
    }

    private ConnectorPageSource createPageSource(UUID shardUuid, OptionalInt bucketNumber, List<ColumnHandle> columns, TupleDomain<RaptorColumnHandle> predicate, OrcReaderOptions orcReaderOptions) {
        List columnHandles = columns.stream().map(RaptorColumnHandle.class::cast).collect(Collectors.toList());
        List<Long> columnIds = columnHandles.stream().map(RaptorColumnHandle::getColumnId).collect(Collectors.toList());
        List<Type> columnTypes = columnHandles.stream().map(RaptorColumnHandle::getColumnType).collect(Collectors.toList());
        return this.storageManager.getPageSource(shardUuid, bucketNumber, columnIds, columnTypes, predicate, orcReaderOptions);
    }
}

