/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.trino.plugin.raptor.legacy.NodeSupplier;
import io.trino.plugin.raptor.legacy.RaptorConnector;
import io.trino.plugin.raptor.legacy.RaptorMetadataFactory;
import io.trino.plugin.raptor.legacy.RaptorNodePartitioningProvider;
import io.trino.plugin.raptor.legacy.RaptorPageSinkProvider;
import io.trino.plugin.raptor.legacy.RaptorPageSourceProvider;
import io.trino.plugin.raptor.legacy.RaptorSessionProperties;
import io.trino.plugin.raptor.legacy.RaptorSplitManager;
import io.trino.plugin.raptor.legacy.RaptorTableProperties;
import io.trino.plugin.raptor.legacy.metadata.Distribution;
import io.trino.plugin.raptor.legacy.metadata.ForMetadata;
import io.trino.plugin.raptor.legacy.metadata.SchemaDaoUtil;
import io.trino.plugin.raptor.legacy.metadata.TableColumn;
import io.trino.plugin.raptor.legacy.systemtables.ShardMetadataSystemTable;
import io.trino.plugin.raptor.legacy.systemtables.TableMetadataSystemTable;
import io.trino.plugin.raptor.legacy.systemtables.TableStatsSystemTable;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.type.TypeManager;
import org.jdbi.v3.core.ConnectionFactory;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;

public class RaptorModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(RaptorConnector.class).in(Scopes.SINGLETON);
        binder.bind(RaptorMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(RaptorSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(RaptorPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(RaptorPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(RaptorNodePartitioningProvider.class).in(Scopes.SINGLETON);
        binder.bind(RaptorSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(RaptorTableProperties.class).in(Scopes.SINGLETON);
        Multibinder tableBinder = Multibinder.newSetBinder((Binder)binder, SystemTable.class);
        tableBinder.addBinding().to(ShardMetadataSystemTable.class).in(Scopes.SINGLETON);
        tableBinder.addBinding().to(TableMetadataSystemTable.class).in(Scopes.SINGLETON);
        tableBinder.addBinding().to(TableStatsSystemTable.class).in(Scopes.SINGLETON);
    }

    @ForMetadata
    @Singleton
    @Provides
    public static Jdbi createJdbi(@ForMetadata ConnectionFactory connectionFactory, TypeManager typeManager) {
        Jdbi dbi = (Jdbi)((Jdbi)Jdbi.create((ConnectionFactory)connectionFactory).installPlugin((JdbiPlugin)new SqlObjectPlugin()).registerRowMapper((RowMapper)new TableColumn.Mapper(typeManager))).registerRowMapper((RowMapper)new Distribution.Mapper(typeManager));
        SchemaDaoUtil.createTablesWithRetry(dbi);
        return dbi;
    }

    @Provides
    @Singleton
    public static NodeSupplier createNodeSupplier(NodeManager nodeManager) {
        return () -> ((NodeManager)nodeManager).getWorkerNodes();
    }
}

