/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.util;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public final class MRJobConfUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MRJobConfUtil.class);
    public static final String REDACTION_REPLACEMENT_VAL = "*********(redacted)";
    public static final float TASK_REPORT_INTERVAL_TO_TIMEOUT_RATIO = 0.01f;
    public static final double PROGRESS_MIN_DELTA_FACTOR = 100.0;
    private static volatile Double progressMinDeltaThreshold = null;
    private static volatile Long progressMaxWaitDeltaTimeThreshold = null;
    private static final String TEST_JVM_SECURITY_EGD_OPT = "-Djava.security.egd=file:/dev/./urandom";

    public static void redact(Configuration conf) {
        for (String prop : conf.getTrimmedStringCollection("mapreduce.job.redacted-properties")) {
            conf.set(prop, REDACTION_REPLACEMENT_VAL);
        }
    }

    private MRJobConfUtil() {
    }

    public static long getTaskProgressReportInterval(Configuration conf) {
        long taskHeartbeatTimeOut = conf.getLong("mapreduce.task.timeout", 300000L);
        return conf.getLong("mapreduce.task.progress-report.interval", (long)(0.01f * (float)taskHeartbeatTimeOut));
    }

    public static void setTaskLogProgressDeltaThresholds(Configuration conf) {
        if (progressMinDeltaThreshold == null) {
            progressMinDeltaThreshold = new Double(100.0 * conf.getDouble("mapreduce.task.log.progress.delta.threshold", 0.05));
        }
        if (progressMaxWaitDeltaTimeThreshold == null) {
            progressMaxWaitDeltaTimeThreshold = TimeUnit.SECONDS.toMillis(conf.getLong("mapreduce.task.log.progress.wait.interval-seconds", 60L));
        }
    }

    public static double getTaskProgressMinDeltaThreshold() {
        if (progressMinDeltaThreshold == null) {
            return 5.0;
        }
        return progressMinDeltaThreshold;
    }

    public static long getTaskProgressWaitDeltaTimeThreshold() {
        if (progressMaxWaitDeltaTimeThreshold == null) {
            return TimeUnit.SECONDS.toMillis(60L);
        }
        return progressMaxWaitDeltaTimeThreshold;
    }

    public static double convertTaskProgressToFactor(float progress) {
        return Math.floor((double)progress * 100.0);
    }

    public static Configuration initEncryptedIntermediateConfigsForTesting(Configuration conf) {
        Configuration config = conf == null ? new Configuration() : conf;
        String childJVMOpts = TEST_JVM_SECURITY_EGD_OPT.concat(" ").concat(config.get("mapred.child.java.opts", " "));
        config.set("yarn.app.mapreduce.am.admin-command-opts", TEST_JVM_SECURITY_EGD_OPT);
        config.set("mapred.child.java.opts", childJVMOpts);
        config.setBoolean("mapreduce.job.encrypted-intermediate-data", true);
        return config;
    }

    public static Configuration setLocalDirectoriesConfigForTesting(Configuration conf, File testRootDir) {
        Configuration config = conf == null ? new Configuration() : conf;
        File hadoopLocalDir = new File(testRootDir, "hadoop-dir");
        if (!hadoopLocalDir.getAbsoluteFile().mkdirs()) {
            LOG.info("{} directory already exists", (Object)hadoopLocalDir.getPath());
        }
        Path mapredHadoopTempDir = new Path(hadoopLocalDir.getPath());
        Path mapredSystemDir = new Path(mapredHadoopTempDir, "system");
        Path stagingDir = new Path(mapredHadoopTempDir, "tmp/staging");
        config.set("mapreduce.jobtracker.staging.root.dir", stagingDir.toString());
        config.set("mapreduce.jobtracker.system.dir", mapredSystemDir.toString());
        config.set("mapreduce.cluster.temp.dir", mapredHadoopTempDir.toString());
        config.set("mapreduce.cluster.local.dir", new Path(mapredHadoopTempDir, "local").toString());
        return config;
    }
}

