/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import io.trino.hadoop.$internal.org.apache.avro.util.Utf8;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobPriorityChange;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobPriorityChangeEvent
implements HistoryEvent {
    private JobPriorityChange datum = new JobPriorityChange();

    public JobPriorityChangeEvent(JobID id, JobPriority priority) {
        this.datum.setJobid(new Utf8(id.toString()));
        this.datum.setPriority(new Utf8(priority.name()));
    }

    JobPriorityChangeEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobPriorityChange)datum;
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.getJobid().toString());
    }

    public JobPriority getPriority() {
        return JobPriority.valueOf(this.datum.getPriority().toString());
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_PRIORITY_CHANGED;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("PRIORITY", (Object)this.getPriority().toString());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        return null;
    }
}

