/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSDirStatAndListingOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.ipc.RetriableException;

final class FSDirAppendOp {
    private FSDirAppendOp() {
    }

    static LastBlockWithStatus appendFile(FSNamesystem fsn, String srcArg, FSPermissionChecker pc, String holder, String clientMachine, boolean newBlock, boolean logRetryCache) throws IOException {
        LocatedBlock lb;
        INodesInPath iip;
        assert (fsn.hasWriteLock());
        FSDirectory fsd = fsn.getFSDirectory();
        fsd.writeLock();
        try {
            iip = fsd.resolvePath(pc, srcArg, FSDirectory.DirOp.WRITE);
            INode inode = iip.getLastINode();
            String path = iip.getPath();
            if (inode != null && inode.isDirectory()) {
                throw new FileAlreadyExistsException("Cannot append to directory " + path + "; already exists as a directory.");
            }
            if (fsd.isPermissionEnabled()) {
                fsd.checkPathAccess(pc, iip, FsAction.WRITE);
            }
            if (inode == null) {
                throw new FileNotFoundException("Failed to append to non-existent file " + path + " for client " + clientMachine);
            }
            INodeFile file = INodeFile.valueOf(inode, path, true);
            if (file.isStriped() && !newBlock) {
                throw new UnsupportedOperationException("Append on EC file without new block is not supported. Use " + (Object)((Object)CreateFlag.NEW_BLOCK) + " create flag while appending file.");
            }
            BlockManager blockManager = fsd.getBlockManager();
            BlockStoragePolicy lpPolicy = blockManager.getStoragePolicy("LAZY_PERSIST");
            if (lpPolicy != null && lpPolicy.getId() == file.getStoragePolicyID()) {
                throw new UnsupportedOperationException("Cannot append to lazy persist file " + path);
            }
            fsn.recoverLeaseInternal(FSNamesystem.RecoverLeaseOp.APPEND_FILE, iip, path, holder, clientMachine, false);
            BlockInfo lastBlock = file.getLastBlock();
            if (lastBlock != null) {
                if (lastBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED) {
                    throw new RetriableException(new NotReplicatedYetException("append: lastBlock=" + lastBlock + " of src=" + path + " is COMMITTED but not yet COMPLETE."));
                }
                if (lastBlock.isComplete() && !blockManager.isSufficientlyReplicated(lastBlock)) {
                    throw new IOException("append: lastBlock=" + lastBlock + " of src=" + path + " is not sufficiently replicated yet.");
                }
            }
            lb = FSDirAppendOp.prepareFileForAppend(fsn, iip, holder, clientMachine, newBlock, true, logRetryCache);
        }
        catch (IOException ie) {
            NameNode.stateChangeLog.warn("DIR* NameSystem.append: " + ie.getMessage());
            throw ie;
        }
        finally {
            fsd.writeUnlock();
        }
        HdfsFileStatus stat = FSDirStatAndListingOp.getFileInfo(fsd, iip, false, false);
        if (lb != null) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.appendFile: file {} for {} at {} block {} block size {}", srcArg, holder, clientMachine, lb.getBlock(), lb.getBlock().getNumBytes());
        }
        return new LastBlockWithStatus(lb, stat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LocatedBlock prepareFileForAppend(FSNamesystem fsn, INodesInPath iip, String leaseHolder, String clientMachine, boolean newBlock, boolean writeToEditLog, boolean logRetryCache) throws IOException {
        assert (fsn.hasWriteLock());
        INodeFile file = iip.getLastINode().asFile();
        QuotaCounts delta = FSDirAppendOp.verifyQuotaForUCBlock(fsn, file, iip);
        file.recordModification(iip.getLatestSnapshotId());
        file.toUnderConstruction(leaseHolder, clientMachine);
        fsn.getLeaseManager().addLease(file.getFileUnderConstructionFeature().getClientName(), file.getId());
        LocatedBlock ret = null;
        if (!newBlock) {
            FSDirectory fsd = fsn.getFSDirectory();
            ret = fsd.getBlockManager().convertLastBlockToUnderConstruction(file, 0L);
            if (ret != null && delta != null) {
                Preconditions.checkState(delta.getStorageSpace() >= 0L, "appending to a block with size larger than the preferred block size");
                fsd.writeLock();
                try {
                    fsd.updateCountNoQuotaCheck(iip, iip.length() - 1, delta);
                }
                finally {
                    fsd.writeUnlock();
                }
            }
        } else {
            BlockInfo lastBlock = file.getLastBlock();
            if (lastBlock != null) {
                ExtendedBlock blk = new ExtendedBlock(fsn.getBlockPoolId(), lastBlock);
                ret = new LocatedBlock(blk, DatanodeInfo.EMPTY_ARRAY);
            }
        }
        if (writeToEditLog) {
            String path = iip.getPath();
            if (NameNodeLayoutVersion.supports(NameNodeLayoutVersion.Feature.APPEND_NEW_BLOCK, fsn.getEffectiveLayoutVersion())) {
                fsn.getEditLog().logAppendFile(path, file, newBlock, logRetryCache);
            } else {
                fsn.getEditLog().logOpenFile(path, file, false, logRetryCache);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QuotaCounts verifyQuotaForUCBlock(FSNamesystem fsn, INodeFile file, INodesInPath iip) throws QuotaExceededException {
        FSDirectory fsd = fsn.getFSDirectory();
        if (!fsn.isImageLoaded() || fsd.shouldSkipQuotaChecks()) {
            return null;
        }
        if (file.getLastBlock() != null) {
            QuotaCounts delta = FSDirAppendOp.computeQuotaDeltaForUCBlock(fsn, file);
            fsd.readLock();
            try {
                FSDirectory.verifyQuota(iip, iip.length() - 1, delta, null);
                QuotaCounts quotaCounts = delta;
                return quotaCounts;
            }
            finally {
                fsd.readUnlock();
            }
        }
        return null;
    }

    private static QuotaCounts computeQuotaDeltaForUCBlock(FSNamesystem fsn, INodeFile file) {
        QuotaCounts delta = new QuotaCounts.Builder().build();
        BlockInfo lastBlock = file.getLastBlock();
        if (lastBlock != null) {
            long diff = file.getPreferredBlockSize() - lastBlock.getNumBytes();
            short repl = lastBlock.getReplication();
            delta.addStorageSpace(diff * (long)repl);
            BlockStoragePolicy policy = fsn.getFSDirectory().getBlockStoragePolicySuite().getPolicy(file.getStoragePolicyID());
            List<StorageType> types = policy.chooseStorageTypes(repl);
            for (StorageType t : types) {
                if (!t.supportTypeQuota()) continue;
                delta.addTypeSpace(t, diff);
            }
        }
        return delta;
    }
}

