/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.function.Function;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.BoundDTExtension;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.LimitedPrivate(value={"authorization-subsystems"})
@InterfaceStability.Unstable
public final class ExtensionHelper {
    private ExtensionHelper() {
    }

    public static void bind(Object extension, URI uri, Configuration conf) throws IOException {
        if (extension instanceof BoundDTExtension) {
            ((BoundDTExtension)extension).bind(uri, conf);
        }
    }

    public static void close(Object extension) {
        ExtensionHelper.ifBoundDTExtension(extension, v -> {
            IOUtils.closeStreams(v);
            return null;
        });
    }

    public static String getUserAgentSuffix(Object extension, String def) {
        return ExtensionHelper.ifBoundDTExtension(extension, BoundDTExtension::getUserAgentSuffix).orElse(def);
    }

    public static String getCanonicalServiceName(Object extension, String def) {
        return ExtensionHelper.ifBoundDTExtension(extension, BoundDTExtension::getCanonicalServiceName).orElse(def);
    }

    public static <V> Optional<V> ifBoundDTExtension(Object extension, Function<? super BoundDTExtension, ? extends V> fn) {
        if (extension instanceof BoundDTExtension) {
            return Optional.of((BoundDTExtension)extension).map(fn);
        }
        return Optional.empty();
    }
}

