/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.AbstractKeyedCheckSumTypeHandler;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.HashProvider;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.enc.provider.DesProvider;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.util.Confounder;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.security.InvalidKeyException;
import javax.crypto.spec.DESKeySpec;

public abstract class ConfounderedDesCheckSum
extends AbstractKeyedCheckSumTypeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConfounderedDesCheckSum.class);

    public ConfounderedDesCheckSum(HashProvider hashProvider, int computeSize, int outputSize) {
        super(new DesProvider(), hashProvider, computeSize, outputSize);
    }

    @Override
    protected byte[] doChecksumWithKey(byte[] data, int start, int len, byte[] key, int usage) throws KrbException {
        int computeSize = this.computeSize();
        int blockSize = this.encProvider().blockSize();
        int hashSize = this.hashProvider().hashSize();
        byte[] workBuffer = new byte[computeSize];
        byte[] conf = Confounder.makeBytes(blockSize);
        byte[] toHash = new byte[blockSize + len];
        System.arraycopy(conf, 0, toHash, 0, blockSize);
        System.arraycopy(data, start, toHash, blockSize, len);
        HashProvider hashProvider = this.hashProvider();
        hashProvider.hash(toHash);
        byte[] hash = hashProvider.output();
        System.arraycopy(conf, 0, workBuffer, 0, blockSize);
        System.arraycopy(hash, 0, workBuffer, blockSize, hashSize);
        byte[] newKey = this.deriveKey(key);
        this.encProvider().encrypt(newKey, workBuffer);
        return workBuffer;
    }

    protected byte[] deriveKey(byte[] key) {
        return this.fixKey(this.xorKey(key));
    }

    protected byte[] xorKey(byte[] key) {
        byte[] xorKey = new byte[this.encProvider().keySize()];
        System.arraycopy(key, 0, xorKey, 0, key.length);
        for (int i = 0; i < xorKey.length; ++i) {
            xorKey[i] = (byte)(xorKey[i] ^ 0xF0);
        }
        return xorKey;
    }

    private byte[] fixKey(byte[] key) {
        boolean isWeak = true;
        try {
            isWeak = DESKeySpec.isWeak(key, 0);
        }
        catch (InvalidKeyException e) {
            LOG.error("Invalid key found. ");
        }
        if (isWeak) {
            key[7] = (byte)(key[7] ^ 0xF0);
        }
        return key;
    }

    @Override
    public boolean verifyWithKey(byte[] data, byte[] key, int usage, byte[] checksum) throws KrbException {
        int blockSize = this.encProvider().blockSize();
        int hashSize = this.hashProvider().hashSize();
        byte[] newKey = this.deriveKey(key);
        this.encProvider().decrypt(newKey, checksum);
        byte[] decrypted = checksum;
        byte[] toHash = new byte[blockSize + data.length];
        System.arraycopy(decrypted, 0, toHash, 0, blockSize);
        System.arraycopy(data, 0, toHash, blockSize, data.length);
        HashProvider hashProvider = this.hashProvider();
        hashProvider.hash(toHash);
        byte[] newHash = hashProvider.output();
        return ConfounderedDesCheckSum.checksumEqual(newHash, decrypted, blockSize, hashSize);
    }
}

