/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.spi.security.ConnectorIdentity;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.fs.FSDataOutputStream;

class HdfsOutputStream
extends FSDataOutputStream {
    private final HdfsEnvironment environment;
    private final ConnectorIdentity identity;

    public HdfsOutputStream(FSDataOutputStream out, HdfsEnvironment environment, HdfsContext context) {
        super((OutputStream)out, null, out.getPos());
        this.environment = environment;
        this.identity = context.getIdentity();
    }

    public OutputStream getWrappedStream() {
        return ((FSDataOutputStream)super.getWrappedStream()).getWrappedStream();
    }

    public void write(int b) throws IOException {
        this.environment.doAs(this.identity, () -> {
            super.write(b);
            return null;
        });
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.environment.doAs(this.identity, () -> {
            super.write(b, off, len);
            return null;
        });
    }
}

