/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import com.google.common.base.VerifyException;
import io.trino.filesystem.Location;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.Path;

public final class HadoopPaths {
    private HadoopPaths() {
    }

    public static Path hadoopPath(Location location) {
        String path = location.toString();
        Path hadoopPath = new Path(path);
        if ("s3".equals(hadoopPath.toUri().getScheme()) && !path.equals(hadoopPath.toString())) {
            return new Path(HadoopPaths.toPathEncodedUri(location));
        }
        return hadoopPath;
    }

    private static URI toPathEncodedUri(Location location) {
        try {
            return new URI(location.scheme().orElse(null), location.host().orElse(null), "/" + location.path(), location.path());
        }
        catch (URISyntaxException e) {
            throw new VerifyException("Failed to convert location to URI: " + location, (Throwable)e);
        }
    }
}

