/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import com.google.common.primitives.Longs;
import io.airlift.slice.SizeOf;
import io.trino.parquet.reader.flat.ColumnAdapter;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import java.util.List;
import java.util.Optional;

public class LongColumnAdapter
implements ColumnAdapter<long[]> {
    public static final LongColumnAdapter LONG_ADAPTER = new LongColumnAdapter();

    @Override
    public long[] createBuffer(int size) {
        return new long[size];
    }

    @Override
    public Block createNonNullBlock(long[] values) {
        return new LongArrayBlock(values.length, Optional.empty(), values);
    }

    @Override
    public Block createNullableBlock(boolean[] nulls, long[] values) {
        return new LongArrayBlock(values.length, Optional.of(nulls), values);
    }

    @Override
    public void copyValue(long[] source, int sourceIndex, long[] destination, int destinationIndex) {
        destination[destinationIndex] = source[sourceIndex];
    }

    @Override
    public void decodeDictionaryIds(long[] values, int offset, int length, int[] ids, long[] dictionary) {
        for (int i = 0; i < length; ++i) {
            values[offset + i] = dictionary[ids[i]];
        }
    }

    @Override
    public long getSizeInBytes(long[] values) {
        return SizeOf.sizeOf((long[])values);
    }

    @Override
    public long[] merge(List<long[]> buffers) {
        return Longs.concat((long[][])((long[][])buffers.toArray(x$0 -> new long[x$0][])));
    }
}

