/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.flat.BinaryBuffer;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.util.Objects;

public class PlainByteArrayDecoders {
    private PlainByteArrayDecoders() {
    }

    private static void skipPlainValues(SimpleSliceInputStream input, int n) {
        for (int i = 0; i < n; ++i) {
            int positionLength = input.readInt();
            input.skip(positionLength);
        }
    }

    private static void createOutputBuffer(BinaryBuffer values, int offset, int length, Slice inputSlice, int outputBufferSize) {
        int inputArrayOffset;
        byte[] inputArray;
        int[] offsets = values.getOffsets();
        byte[] outputBuffer = new byte[outputBufferSize];
        int currentInputOffset = 0;
        int currentOutputOffset = 0;
        if (length != 0) {
            inputArray = inputSlice.byteArray();
            inputArrayOffset = inputSlice.byteArrayOffset();
        } else {
            inputArray = new byte[]{};
            inputArrayOffset = 0;
        }
        for (int i = 0; i < length; ++i) {
            int inputPositionLength = inputSlice.getInt(currentInputOffset);
            int outputPositionLength = offsets[offset + i + 1];
            System.arraycopy(inputArray, inputArrayOffset + currentInputOffset + 4, outputBuffer, currentOutputOffset, outputPositionLength);
            offsets[offset + i + 1] = offsets[offset + i] + outputPositionLength;
            currentInputOffset += inputPositionLength + 4;
            currentOutputOffset += outputPositionLength;
        }
        values.addChunk(Slices.wrappedBuffer((byte[])outputBuffer));
    }

    public static final class BinaryPlainValueDecoder
    implements ValueDecoder<BinaryBuffer> {
        private SimpleSliceInputStream input;

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public void read(BinaryBuffer values, int offset, int length) {
            Slice inputSlice = this.input.asSlice();
            int[] offsets = values.getOffsets();
            int currentInputOffset = 0;
            int outputBufferSize = 0;
            for (int i = 0; i < length; ++i) {
                int positionLength;
                offsets[offset + i + 1] = positionLength = inputSlice.getInt(currentInputOffset);
                outputBufferSize += positionLength;
                currentInputOffset += positionLength + 4;
            }
            PlainByteArrayDecoders.createOutputBuffer(values, offset, length, inputSlice, outputBufferSize);
            this.input.skip(currentInputOffset);
        }

        @Override
        public void skip(int n) {
            PlainByteArrayDecoders.skipPlainValues(this.input, n);
        }
    }

    public static final class CharPlainValueDecoder
    implements ValueDecoder<BinaryBuffer> {
        private final int maxLength;
        private SimpleSliceInputStream input;

        public CharPlainValueDecoder(CharType charType) {
            this.maxLength = charType.getLength();
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public void read(BinaryBuffer values, int offset, int length) {
            Slice inputSlice = this.input.asSlice();
            int[] offsets = values.getOffsets();
            int currentInputOffset = 0;
            int outputBufferSize = 0;
            for (int i = offset; i < offset + length; ++i) {
                int outputLength;
                int positionLength = inputSlice.getInt(currentInputOffset);
                offsets[i + 1] = outputLength = Chars.byteCountWithoutTrailingSpace((Slice)inputSlice, (int)(currentInputOffset += 4), (int)positionLength, (int)this.maxLength);
                outputBufferSize += outputLength;
                currentInputOffset += positionLength;
            }
            PlainByteArrayDecoders.createOutputBuffer(values, offset, length, inputSlice, outputBufferSize);
            this.input.skip(currentInputOffset);
        }

        @Override
        public void skip(int n) {
            PlainByteArrayDecoders.skipPlainValues(this.input, n);
        }
    }

    public static final class BoundedVarcharPlainValueDecoder
    implements ValueDecoder<BinaryBuffer> {
        private final int boundedLength;
        private SimpleSliceInputStream input;

        public BoundedVarcharPlainValueDecoder(VarcharType varcharType) {
            Preconditions.checkArgument((!varcharType.isUnbounded() ? 1 : 0) != 0, (String)"Trino type %s is not a bounded varchar", (Object)varcharType);
            this.boundedLength = varcharType.getBoundedLength();
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public void read(BinaryBuffer values, int offset, int length) {
            Slice inputSlice = this.input.asSlice();
            int[] offsets = values.getOffsets();
            int currentInputOffset = 0;
            int outputBufferSize = 0;
            for (int i = offset; i < offset + length; ++i) {
                int outputLength;
                int positionLength = inputSlice.getInt(currentInputOffset);
                offsets[i + 1] = outputLength = Varchars.byteCount((Slice)inputSlice, (int)(currentInputOffset += 4), (int)positionLength, (int)this.boundedLength);
                outputBufferSize += outputLength;
                currentInputOffset += positionLength;
            }
            PlainByteArrayDecoders.createOutputBuffer(values, offset, length, inputSlice, outputBufferSize);
            this.input.skip(currentInputOffset);
        }

        @Override
        public void skip(int n) {
            PlainByteArrayDecoders.skipPlainValues(this.input, n);
        }
    }
}

