/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ByteBitUnpacker;

public final class ByteBitUnpackers {
    private static final ByteBitUnpacker[] UNPACKERS = new ByteBitUnpacker[]{new Unpacker1(), new Unpacker2(), new Unpacker3(), new Unpacker4(), new Unpacker5(), new Unpacker6(), new Unpacker7(), new Unpacker8(), new Unpacker9()};

    public static ByteBitUnpacker getByteBitUnpacker(int bitWidth) {
        Preconditions.checkArgument((bitWidth > 0 && bitWidth <= 9 ? 1 : 0) != 0, (String)"bitWidth %s should be in the range 1-9", (int)bitWidth);
        return UNPACKERS[bitWidth - 1];
    }

    private ByteBitUnpackers() {
    }

    private static final class Unpacker1
    implements ByteBitUnpacker {
        private Unpacker1() {
        }

        @Override
        public void unpack(byte[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker1.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(byte[] output, int outputOffset, SimpleSliceInputStream input) {
            int v0 = input.readInt();
            output[outputOffset] = (byte)((long)v0 & 1L);
            output[outputOffset + 1] = (byte)((long)(v0 >>> 1) & 1L);
            output[outputOffset + 2] = (byte)((long)(v0 >>> 2) & 1L);
            output[outputOffset + 3] = (byte)((long)(v0 >>> 3) & 1L);
            output[outputOffset + 4] = (byte)((long)(v0 >>> 4) & 1L);
            output[outputOffset + 5] = (byte)((long)(v0 >>> 5) & 1L);
            output[outputOffset + 6] = (byte)((long)(v0 >>> 6) & 1L);
            output[outputOffset + 7] = (byte)((long)(v0 >>> 7) & 1L);
            output[outputOffset + 8] = (byte)((long)(v0 >>> 8) & 1L);
            output[outputOffset + 9] = (byte)((long)(v0 >>> 9) & 1L);
            output[outputOffset + 10] = (byte)((long)(v0 >>> 10) & 1L);
            output[outputOffset + 11] = (byte)((long)(v0 >>> 11) & 1L);
            output[outputOffset + 12] = (byte)((long)(v0 >>> 12) & 1L);
            output[outputOffset + 13] = (byte)((long)(v0 >>> 13) & 1L);
            output[outputOffset + 14] = (byte)((long)(v0 >>> 14) & 1L);
            output[outputOffset + 15] = (byte)((long)(v0 >>> 15) & 1L);
            output[outputOffset + 16] = (byte)((long)(v0 >>> 16) & 1L);
            output[outputOffset + 17] = (byte)((long)(v0 >>> 17) & 1L);
            output[outputOffset + 18] = (byte)((long)(v0 >>> 18) & 1L);
            output[outputOffset + 19] = (byte)((long)(v0 >>> 19) & 1L);
            output[outputOffset + 20] = (byte)((long)(v0 >>> 20) & 1L);
            output[outputOffset + 21] = (byte)((long)(v0 >>> 21) & 1L);
            output[outputOffset + 22] = (byte)((long)(v0 >>> 22) & 1L);
            output[outputOffset + 23] = (byte)((long)(v0 >>> 23) & 1L);
            output[outputOffset + 24] = (byte)((long)(v0 >>> 24) & 1L);
            output[outputOffset + 25] = (byte)((long)(v0 >>> 25) & 1L);
            output[outputOffset + 26] = (byte)((long)(v0 >>> 26) & 1L);
            output[outputOffset + 27] = (byte)((long)(v0 >>> 27) & 1L);
            output[outputOffset + 28] = (byte)((long)(v0 >>> 28) & 1L);
            output[outputOffset + 29] = (byte)((long)(v0 >>> 29) & 1L);
            output[outputOffset + 30] = (byte)((long)(v0 >>> 30) & 1L);
            output[outputOffset + 31] = (byte)((long)(v0 >>> 31) & 1L);
        }
    }

    private static final class Unpacker2
    implements ByteBitUnpacker {
        private Unpacker2() {
        }

        @Override
        public void unpack(byte[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker2.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(byte[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            output[outputOffset] = (byte)(v0 & 3L);
            output[outputOffset + 1] = (byte)(v0 >>> 2 & 3L);
            output[outputOffset + 2] = (byte)(v0 >>> 4 & 3L);
            output[outputOffset + 3] = (byte)(v0 >>> 6 & 3L);
            output[outputOffset + 4] = (byte)(v0 >>> 8 & 3L);
            output[outputOffset + 5] = (byte)(v0 >>> 10 & 3L);
            output[outputOffset + 6] = (byte)(v0 >>> 12 & 3L);
            output[outputOffset + 7] = (byte)(v0 >>> 14 & 3L);
            output[outputOffset + 8] = (byte)(v0 >>> 16 & 3L);
            output[outputOffset + 9] = (byte)(v0 >>> 18 & 3L);
            output[outputOffset + 10] = (byte)(v0 >>> 20 & 3L);
            output[outputOffset + 11] = (byte)(v0 >>> 22 & 3L);
            output[outputOffset + 12] = (byte)(v0 >>> 24 & 3L);
            output[outputOffset + 13] = (byte)(v0 >>> 26 & 3L);
            output[outputOffset + 14] = (byte)(v0 >>> 28 & 3L);
            output[outputOffset + 15] = (byte)(v0 >>> 30 & 3L);
            output[outputOffset + 16] = (byte)(v0 >>> 32 & 3L);
            output[outputOffset + 17] = (byte)(v0 >>> 34 & 3L);
            output[outputOffset + 18] = (byte)(v0 >>> 36 & 3L);
            output[outputOffset + 19] = (byte)(v0 >>> 38 & 3L);
            output[outputOffset + 20] = (byte)(v0 >>> 40 & 3L);
            output[outputOffset + 21] = (byte)(v0 >>> 42 & 3L);
            output[outputOffset + 22] = (byte)(v0 >>> 44 & 3L);
            output[outputOffset + 23] = (byte)(v0 >>> 46 & 3L);
            output[outputOffset + 24] = (byte)(v0 >>> 48 & 3L);
            output[outputOffset + 25] = (byte)(v0 >>> 50 & 3L);
            output[outputOffset + 26] = (byte)(v0 >>> 52 & 3L);
            output[outputOffset + 27] = (byte)(v0 >>> 54 & 3L);
            output[outputOffset + 28] = (byte)(v0 >>> 56 & 3L);
            output[outputOffset + 29] = (byte)(v0 >>> 58 & 3L);
            output[outputOffset + 30] = (byte)(v0 >>> 60 & 3L);
            output[outputOffset + 31] = (byte)(v0 >>> 62 & 3L);
        }
    }

    private static final class Unpacker3
    implements ByteBitUnpacker {
        private Unpacker3() {
        }

        @Override
        public void unpack(byte[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker3.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(byte[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            int v1 = input.readInt();
            output[outputOffset] = (byte)(v0 & 7L);
            output[outputOffset + 1] = (byte)(v0 >>> 3 & 7L);
            output[outputOffset + 2] = (byte)(v0 >>> 6 & 7L);
            output[outputOffset + 3] = (byte)(v0 >>> 9 & 7L);
            output[outputOffset + 4] = (byte)(v0 >>> 12 & 7L);
            output[outputOffset + 5] = (byte)(v0 >>> 15 & 7L);
            output[outputOffset + 6] = (byte)(v0 >>> 18 & 7L);
            output[outputOffset + 7] = (byte)(v0 >>> 21 & 7L);
            output[outputOffset + 8] = (byte)(v0 >>> 24 & 7L);
            output[outputOffset + 9] = (byte)(v0 >>> 27 & 7L);
            output[outputOffset + 10] = (byte)(v0 >>> 30 & 7L);
            output[outputOffset + 11] = (byte)(v0 >>> 33 & 7L);
            output[outputOffset + 12] = (byte)(v0 >>> 36 & 7L);
            output[outputOffset + 13] = (byte)(v0 >>> 39 & 7L);
            output[outputOffset + 14] = (byte)(v0 >>> 42 & 7L);
            output[outputOffset + 15] = (byte)(v0 >>> 45 & 7L);
            output[outputOffset + 16] = (byte)(v0 >>> 48 & 7L);
            output[outputOffset + 17] = (byte)(v0 >>> 51 & 7L);
            output[outputOffset + 18] = (byte)(v0 >>> 54 & 7L);
            output[outputOffset + 19] = (byte)(v0 >>> 57 & 7L);
            output[outputOffset + 20] = (byte)(v0 >>> 60 & 7L);
            output[outputOffset + 21] = (byte)(v0 >>> 63 & 1L | ((long)v1 & 3L) << 1);
            output[outputOffset + 22] = (byte)((long)(v1 >>> 2) & 7L);
            output[outputOffset + 23] = (byte)((long)(v1 >>> 5) & 7L);
            output[outputOffset + 24] = (byte)((long)(v1 >>> 8) & 7L);
            output[outputOffset + 25] = (byte)((long)(v1 >>> 11) & 7L);
            output[outputOffset + 26] = (byte)((long)(v1 >>> 14) & 7L);
            output[outputOffset + 27] = (byte)((long)(v1 >>> 17) & 7L);
            output[outputOffset + 28] = (byte)((long)(v1 >>> 20) & 7L);
            output[outputOffset + 29] = (byte)((long)(v1 >>> 23) & 7L);
            output[outputOffset + 30] = (byte)((long)(v1 >>> 26) & 7L);
            output[outputOffset + 31] = (byte)((long)(v1 >>> 29) & 7L);
        }
    }

    private static final class Unpacker4
    implements ByteBitUnpacker {
        private Unpacker4() {
        }

        @Override
        public void unpack(byte[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker4.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(byte[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            output[outputOffset] = (byte)(v0 & 0xFL);
            output[outputOffset + 1] = (byte)(v0 >>> 4 & 0xFL);
            output[outputOffset + 2] = (byte)(v0 >>> 8 & 0xFL);
            output[outputOffset + 3] = (byte)(v0 >>> 12 & 0xFL);
            output[outputOffset + 4] = (byte)(v0 >>> 16 & 0xFL);
            output[outputOffset + 5] = (byte)(v0 >>> 20 & 0xFL);
            output[outputOffset + 6] = (byte)(v0 >>> 24 & 0xFL);
            output[outputOffset + 7] = (byte)(v0 >>> 28 & 0xFL);
            output[outputOffset + 8] = (byte)(v0 >>> 32 & 0xFL);
            output[outputOffset + 9] = (byte)(v0 >>> 36 & 0xFL);
            output[outputOffset + 10] = (byte)(v0 >>> 40 & 0xFL);
            output[outputOffset + 11] = (byte)(v0 >>> 44 & 0xFL);
            output[outputOffset + 12] = (byte)(v0 >>> 48 & 0xFL);
            output[outputOffset + 13] = (byte)(v0 >>> 52 & 0xFL);
            output[outputOffset + 14] = (byte)(v0 >>> 56 & 0xFL);
            output[outputOffset + 15] = (byte)(v0 >>> 60 & 0xFL);
            output[outputOffset + 16] = (byte)(v1 & 0xFL);
            output[outputOffset + 17] = (byte)(v1 >>> 4 & 0xFL);
            output[outputOffset + 18] = (byte)(v1 >>> 8 & 0xFL);
            output[outputOffset + 19] = (byte)(v1 >>> 12 & 0xFL);
            output[outputOffset + 20] = (byte)(v1 >>> 16 & 0xFL);
            output[outputOffset + 21] = (byte)(v1 >>> 20 & 0xFL);
            output[outputOffset + 22] = (byte)(v1 >>> 24 & 0xFL);
            output[outputOffset + 23] = (byte)(v1 >>> 28 & 0xFL);
            output[outputOffset + 24] = (byte)(v1 >>> 32 & 0xFL);
            output[outputOffset + 25] = (byte)(v1 >>> 36 & 0xFL);
            output[outputOffset + 26] = (byte)(v1 >>> 40 & 0xFL);
            output[outputOffset + 27] = (byte)(v1 >>> 44 & 0xFL);
            output[outputOffset + 28] = (byte)(v1 >>> 48 & 0xFL);
            output[outputOffset + 29] = (byte)(v1 >>> 52 & 0xFL);
            output[outputOffset + 30] = (byte)(v1 >>> 56 & 0xFL);
            output[outputOffset + 31] = (byte)(v1 >>> 60 & 0xFL);
        }
    }

    private static final class Unpacker5
    implements ByteBitUnpacker {
        private Unpacker5() {
        }

        @Override
        public void unpack(byte[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker5.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(byte[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            int v2 = input.readInt();
            output[outputOffset] = (byte)(v0 & 0x1FL);
            output[outputOffset + 1] = (byte)(v0 >>> 5 & 0x1FL);
            output[outputOffset + 2] = (byte)(v0 >>> 10 & 0x1FL);
            output[outputOffset + 3] = (byte)(v0 >>> 15 & 0x1FL);
            output[outputOffset + 4] = (byte)(v0 >>> 20 & 0x1FL);
            output[outputOffset + 5] = (byte)(v0 >>> 25 & 0x1FL);
            output[outputOffset + 6] = (byte)(v0 >>> 30 & 0x1FL);
            output[outputOffset + 7] = (byte)(v0 >>> 35 & 0x1FL);
            output[outputOffset + 8] = (byte)(v0 >>> 40 & 0x1FL);
            output[outputOffset + 9] = (byte)(v0 >>> 45 & 0x1FL);
            output[outputOffset + 10] = (byte)(v0 >>> 50 & 0x1FL);
            output[outputOffset + 11] = (byte)(v0 >>> 55 & 0x1FL);
            output[outputOffset + 12] = (byte)(v0 >>> 60 & 0xFL | (v1 & 1L) << 4);
            output[outputOffset + 13] = (byte)(v1 >>> 1 & 0x1FL);
            output[outputOffset + 14] = (byte)(v1 >>> 6 & 0x1FL);
            output[outputOffset + 15] = (byte)(v1 >>> 11 & 0x1FL);
            output[outputOffset + 16] = (byte)(v1 >>> 16 & 0x1FL);
            output[outputOffset + 17] = (byte)(v1 >>> 21 & 0x1FL);
            output[outputOffset + 18] = (byte)(v1 >>> 26 & 0x1FL);
            output[outputOffset + 19] = (byte)(v1 >>> 31 & 0x1FL);
            output[outputOffset + 20] = (byte)(v1 >>> 36 & 0x1FL);
            output[outputOffset + 21] = (byte)(v1 >>> 41 & 0x1FL);
            output[outputOffset + 22] = (byte)(v1 >>> 46 & 0x1FL);
            output[outputOffset + 23] = (byte)(v1 >>> 51 & 0x1FL);
            output[outputOffset + 24] = (byte)(v1 >>> 56 & 0x1FL);
            output[outputOffset + 25] = (byte)(v1 >>> 61 & 7L | ((long)v2 & 3L) << 3);
            output[outputOffset + 26] = (byte)((long)(v2 >>> 2) & 0x1FL);
            output[outputOffset + 27] = (byte)((long)(v2 >>> 7) & 0x1FL);
            output[outputOffset + 28] = (byte)((long)(v2 >>> 12) & 0x1FL);
            output[outputOffset + 29] = (byte)((long)(v2 >>> 17) & 0x1FL);
            output[outputOffset + 30] = (byte)((long)(v2 >>> 22) & 0x1FL);
            output[outputOffset + 31] = (byte)((long)(v2 >>> 27) & 0x1FL);
        }
    }

    private static final class Unpacker6
    implements ByteBitUnpacker {
        private Unpacker6() {
        }

        @Override
        public void unpack(byte[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker6.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(byte[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            output[outputOffset] = (byte)(v0 & 0x3FL);
            output[outputOffset + 1] = (byte)(v0 >>> 6 & 0x3FL);
            output[outputOffset + 2] = (byte)(v0 >>> 12 & 0x3FL);
            output[outputOffset + 3] = (byte)(v0 >>> 18 & 0x3FL);
            output[outputOffset + 4] = (byte)(v0 >>> 24 & 0x3FL);
            output[outputOffset + 5] = (byte)(v0 >>> 30 & 0x3FL);
            output[outputOffset + 6] = (byte)(v0 >>> 36 & 0x3FL);
            output[outputOffset + 7] = (byte)(v0 >>> 42 & 0x3FL);
            output[outputOffset + 8] = (byte)(v0 >>> 48 & 0x3FL);
            output[outputOffset + 9] = (byte)(v0 >>> 54 & 0x3FL);
            output[outputOffset + 10] = (byte)(v0 >>> 60 & 0xFL | (v1 & 3L) << 4);
            output[outputOffset + 11] = (byte)(v1 >>> 2 & 0x3FL);
            output[outputOffset + 12] = (byte)(v1 >>> 8 & 0x3FL);
            output[outputOffset + 13] = (byte)(v1 >>> 14 & 0x3FL);
            output[outputOffset + 14] = (byte)(v1 >>> 20 & 0x3FL);
            output[outputOffset + 15] = (byte)(v1 >>> 26 & 0x3FL);
            output[outputOffset + 16] = (byte)(v1 >>> 32 & 0x3FL);
            output[outputOffset + 17] = (byte)(v1 >>> 38 & 0x3FL);
            output[outputOffset + 18] = (byte)(v1 >>> 44 & 0x3FL);
            output[outputOffset + 19] = (byte)(v1 >>> 50 & 0x3FL);
            output[outputOffset + 20] = (byte)(v1 >>> 56 & 0x3FL);
            output[outputOffset + 21] = (byte)(v1 >>> 62 & 3L | (v2 & 0xFL) << 2);
            output[outputOffset + 22] = (byte)(v2 >>> 4 & 0x3FL);
            output[outputOffset + 23] = (byte)(v2 >>> 10 & 0x3FL);
            output[outputOffset + 24] = (byte)(v2 >>> 16 & 0x3FL);
            output[outputOffset + 25] = (byte)(v2 >>> 22 & 0x3FL);
            output[outputOffset + 26] = (byte)(v2 >>> 28 & 0x3FL);
            output[outputOffset + 27] = (byte)(v2 >>> 34 & 0x3FL);
            output[outputOffset + 28] = (byte)(v2 >>> 40 & 0x3FL);
            output[outputOffset + 29] = (byte)(v2 >>> 46 & 0x3FL);
            output[outputOffset + 30] = (byte)(v2 >>> 52 & 0x3FL);
            output[outputOffset + 31] = (byte)(v2 >>> 58 & 0x3FL);
        }
    }

    private static final class Unpacker7
    implements ByteBitUnpacker {
        private Unpacker7() {
        }

        @Override
        public void unpack(byte[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker7.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(byte[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            int v3 = input.readInt();
            output[outputOffset] = (byte)(v0 & 0x7FL);
            output[outputOffset + 1] = (byte)(v0 >>> 7 & 0x7FL);
            output[outputOffset + 2] = (byte)(v0 >>> 14 & 0x7FL);
            output[outputOffset + 3] = (byte)(v0 >>> 21 & 0x7FL);
            output[outputOffset + 4] = (byte)(v0 >>> 28 & 0x7FL);
            output[outputOffset + 5] = (byte)(v0 >>> 35 & 0x7FL);
            output[outputOffset + 6] = (byte)(v0 >>> 42 & 0x7FL);
            output[outputOffset + 7] = (byte)(v0 >>> 49 & 0x7FL);
            output[outputOffset + 8] = (byte)(v0 >>> 56 & 0x7FL);
            output[outputOffset + 9] = (byte)(v0 >>> 63 & 1L | (v1 & 0x3FL) << 1);
            output[outputOffset + 10] = (byte)(v1 >>> 6 & 0x7FL);
            output[outputOffset + 11] = (byte)(v1 >>> 13 & 0x7FL);
            output[outputOffset + 12] = (byte)(v1 >>> 20 & 0x7FL);
            output[outputOffset + 13] = (byte)(v1 >>> 27 & 0x7FL);
            output[outputOffset + 14] = (byte)(v1 >>> 34 & 0x7FL);
            output[outputOffset + 15] = (byte)(v1 >>> 41 & 0x7FL);
            output[outputOffset + 16] = (byte)(v1 >>> 48 & 0x7FL);
            output[outputOffset + 17] = (byte)(v1 >>> 55 & 0x7FL);
            output[outputOffset + 18] = (byte)(v1 >>> 62 & 3L | (v2 & 0x1FL) << 2);
            output[outputOffset + 19] = (byte)(v2 >>> 5 & 0x7FL);
            output[outputOffset + 20] = (byte)(v2 >>> 12 & 0x7FL);
            output[outputOffset + 21] = (byte)(v2 >>> 19 & 0x7FL);
            output[outputOffset + 22] = (byte)(v2 >>> 26 & 0x7FL);
            output[outputOffset + 23] = (byte)(v2 >>> 33 & 0x7FL);
            output[outputOffset + 24] = (byte)(v2 >>> 40 & 0x7FL);
            output[outputOffset + 25] = (byte)(v2 >>> 47 & 0x7FL);
            output[outputOffset + 26] = (byte)(v2 >>> 54 & 0x7FL);
            output[outputOffset + 27] = (byte)(v2 >>> 61 & 7L | ((long)v3 & 0xFL) << 3);
            output[outputOffset + 28] = (byte)((long)(v3 >>> 4) & 0x7FL);
            output[outputOffset + 29] = (byte)((long)(v3 >>> 11) & 0x7FL);
            output[outputOffset + 30] = (byte)((long)(v3 >>> 18) & 0x7FL);
            output[outputOffset + 31] = (byte)((long)(v3 >>> 25) & 0x7FL);
        }
    }

    private static final class Unpacker8
    implements ByteBitUnpacker {
        private Unpacker8() {
        }

        @Override
        public void unpack(byte[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            input.readBytes(output, outputOffset, length);
        }
    }

    private static final class Unpacker9
    implements ByteBitUnpacker {
        private Unpacker9() {
        }

        @Override
        public void unpack(byte[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker9.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
        }

        private static void unpack32(byte[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            int v4 = input.readInt();
            output[outputOffset] = (byte)v0;
            output[outputOffset + 1] = (byte)(v0 >>> 9 & 0x1FFL);
            output[outputOffset + 2] = (byte)(v0 >>> 18 & 0x1FFL);
            output[outputOffset + 3] = (byte)(v0 >>> 27 & 0x1FFL);
            output[outputOffset + 4] = (byte)(v0 >>> 36 & 0x1FFL);
            output[outputOffset + 5] = (byte)(v0 >>> 45 & 0x1FFL);
            output[outputOffset + 6] = (byte)(v0 >>> 54 & 0x1FFL);
            output[outputOffset + 7] = (byte)(v0 >>> 63 | (v1 & 0xFFL) << 1);
            output[outputOffset + 8] = (byte)(v1 >>> 8 & 0x1FFL);
            output[outputOffset + 9] = (byte)(v1 >>> 17 & 0x1FFL);
            output[outputOffset + 10] = (byte)(v1 >>> 26 & 0x1FFL);
            output[outputOffset + 11] = (byte)(v1 >>> 35 & 0x1FFL);
            output[outputOffset + 12] = (byte)(v1 >>> 44 & 0x1FFL);
            output[outputOffset + 13] = (byte)(v1 >>> 53 & 0x1FFL);
            output[outputOffset + 14] = (byte)(v1 >>> 62 | (v2 & 0x7FL) << 2);
            output[outputOffset + 15] = (byte)(v2 >>> 7 & 0x1FFL);
            output[outputOffset + 16] = (byte)(v2 >>> 16 & 0x1FFL);
            output[outputOffset + 17] = (byte)(v2 >>> 25 & 0x1FFL);
            output[outputOffset + 18] = (byte)(v2 >>> 34 & 0x1FFL);
            output[outputOffset + 19] = (byte)(v2 >>> 43 & 0x1FFL);
            output[outputOffset + 20] = (byte)(v2 >>> 52 & 0x1FFL);
            output[outputOffset + 21] = (byte)(v2 >>> 61 | (v3 & 0x3FL) << 3);
            output[outputOffset + 22] = (byte)(v3 >>> 6 & 0x1FFL);
            output[outputOffset + 23] = (byte)(v3 >>> 15 & 0x1FFL);
            output[outputOffset + 24] = (byte)(v3 >>> 24 & 0x1FFL);
            output[outputOffset + 25] = (byte)(v3 >>> 33 & 0x1FFL);
            output[outputOffset + 26] = (byte)(v3 >>> 42 & 0x1FFL);
            output[outputOffset + 27] = (byte)(v3 >>> 51 & 0x1FFL);
            output[outputOffset + 28] = (byte)(v3 >>> 60 | ((long)v4 & 0x1FL) << 4);
            output[outputOffset + 29] = (byte)((long)(v4 >>> 5) & 0x1FFL);
            output[outputOffset + 30] = (byte)((long)(v4 >>> 14) & 0x1FFL);
            output[outputOffset + 31] = (byte)((long)(v4 >>> 23) & 0x1FFL);
        }
    }
}

