/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.parquet.PrimitiveField;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;

public class TimestampMicrosColumnReader
extends PrimitiveColumnReader {
    public TimestampMicrosColumnReader(PrimitiveField field) {
        super(field);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        long epochMicros = this.valuesReader.readLong();
        if (type == TimestampType.TIMESTAMP_MILLIS) {
            type.writeLong(blockBuilder, Timestamps.round((long)epochMicros, (int)3));
        } else if (type == TimestampType.TIMESTAMP_MICROS) {
            type.writeLong(blockBuilder, epochMicros);
        } else if (type == TimestampType.TIMESTAMP_NANOS) {
            type.writeObject(blockBuilder, (Object)new LongTimestamp(epochMicros, 0));
        } else if (type == TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS) {
            long epochMillis = Timestamps.round((long)epochMicros, (int)3) / 1000L;
            type.writeLong(blockBuilder, DateTimeEncoding.packDateTimeWithZone((long)epochMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        } else if (type == TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS || type == TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS) {
            long epochMillis = Math.floorDiv(epochMicros, 1000);
            int picosOfMillis = Math.toIntExact(Math.floorMod(epochMicros, 1000)) * 1000000;
            type.writeObject(blockBuilder, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)picosOfMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        } else if (type == BigintType.BIGINT) {
            type.writeLong(blockBuilder, epochMicros);
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Trino column type (%s) for Parquet column (%s)", type, this.field.getDescriptor()));
        }
    }
}

