/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.util.Objects;

public class ParquetReaderOptions {
    private static final DataSize DEFAULT_MAX_READ_BLOCK_SIZE = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final int DEFAULT_MAX_READ_BLOCK_ROW_COUNT = 8192;
    private static final DataSize DEFAULT_MAX_MERGE_DISTANCE = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_MAX_BUFFER_SIZE = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private final boolean ignoreStatistics;
    private final DataSize maxReadBlockSize;
    private final int maxReadBlockRowCount;
    private final DataSize maxMergeDistance;
    private final DataSize maxBufferSize;
    private final boolean useColumnIndex;
    private final boolean useBatchColumnReaders;
    private final boolean useBatchNestedColumnReaders;
    private final boolean useBloomFilter;

    public ParquetReaderOptions() {
        this.ignoreStatistics = false;
        this.maxReadBlockSize = DEFAULT_MAX_READ_BLOCK_SIZE;
        this.maxReadBlockRowCount = 8192;
        this.maxMergeDistance = DEFAULT_MAX_MERGE_DISTANCE;
        this.maxBufferSize = DEFAULT_MAX_BUFFER_SIZE;
        this.useColumnIndex = true;
        this.useBatchColumnReaders = true;
        this.useBatchNestedColumnReaders = true;
        this.useBloomFilter = true;
    }

    private ParquetReaderOptions(boolean ignoreStatistics, DataSize maxReadBlockSize, int maxReadBlockRowCount, DataSize maxMergeDistance, DataSize maxBufferSize, boolean useColumnIndex, boolean useBatchColumnReaders, boolean useBatchNestedColumnReaders, boolean useBloomFilter) {
        this.ignoreStatistics = ignoreStatistics;
        this.maxReadBlockSize = Objects.requireNonNull(maxReadBlockSize, "maxReadBlockSize is null");
        Preconditions.checkArgument((maxReadBlockRowCount > 0 ? 1 : 0) != 0, (Object)"maxReadBlockRowCount must be greater than 0");
        this.maxReadBlockRowCount = maxReadBlockRowCount;
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBufferSize = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        this.useColumnIndex = useColumnIndex;
        this.useBatchColumnReaders = useBatchColumnReaders;
        this.useBatchNestedColumnReaders = useBatchNestedColumnReaders;
        this.useBloomFilter = useBloomFilter;
    }

    public boolean isIgnoreStatistics() {
        return this.ignoreStatistics;
    }

    public DataSize getMaxReadBlockSize() {
        return this.maxReadBlockSize;
    }

    public DataSize getMaxMergeDistance() {
        return this.maxMergeDistance;
    }

    public boolean isUseColumnIndex() {
        return this.useColumnIndex;
    }

    public boolean useBatchColumnReaders() {
        return this.useBatchColumnReaders;
    }

    public boolean useBatchNestedColumnReaders() {
        return this.useBatchNestedColumnReaders;
    }

    public boolean useBloomFilter() {
        return this.useBloomFilter;
    }

    public DataSize getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public int getMaxReadBlockRowCount() {
        return this.maxReadBlockRowCount;
    }

    public ParquetReaderOptions withIgnoreStatistics(boolean ignoreStatistics) {
        return new ParquetReaderOptions(ignoreStatistics, this.maxReadBlockSize, this.maxReadBlockRowCount, this.maxMergeDistance, this.maxBufferSize, this.useColumnIndex, this.useBatchColumnReaders, this.useBatchNestedColumnReaders, this.useBloomFilter);
    }

    public ParquetReaderOptions withMaxReadBlockSize(DataSize maxReadBlockSize) {
        return new ParquetReaderOptions(this.ignoreStatistics, maxReadBlockSize, this.maxReadBlockRowCount, this.maxMergeDistance, this.maxBufferSize, this.useColumnIndex, this.useBatchColumnReaders, this.useBatchNestedColumnReaders, this.useBloomFilter);
    }

    public ParquetReaderOptions withMaxReadBlockRowCount(int maxReadBlockRowCount) {
        return new ParquetReaderOptions(this.ignoreStatistics, this.maxReadBlockSize, maxReadBlockRowCount, this.maxMergeDistance, this.maxBufferSize, this.useColumnIndex, this.useBatchColumnReaders, this.useBatchNestedColumnReaders, this.useBloomFilter);
    }

    public ParquetReaderOptions withMaxMergeDistance(DataSize maxMergeDistance) {
        return new ParquetReaderOptions(this.ignoreStatistics, this.maxReadBlockSize, this.maxReadBlockRowCount, maxMergeDistance, this.maxBufferSize, this.useColumnIndex, this.useBatchColumnReaders, this.useBatchNestedColumnReaders, this.useBloomFilter);
    }

    public ParquetReaderOptions withMaxBufferSize(DataSize maxBufferSize) {
        return new ParquetReaderOptions(this.ignoreStatistics, this.maxReadBlockSize, this.maxReadBlockRowCount, this.maxMergeDistance, maxBufferSize, this.useColumnIndex, this.useBatchColumnReaders, this.useBatchNestedColumnReaders, this.useBloomFilter);
    }

    public ParquetReaderOptions withUseColumnIndex(boolean useColumnIndex) {
        return new ParquetReaderOptions(this.ignoreStatistics, this.maxReadBlockSize, this.maxReadBlockRowCount, this.maxMergeDistance, this.maxBufferSize, useColumnIndex, this.useBatchColumnReaders, this.useBatchNestedColumnReaders, this.useBloomFilter);
    }

    public ParquetReaderOptions withBatchColumnReaders(boolean useBatchColumnReaders) {
        return new ParquetReaderOptions(this.ignoreStatistics, this.maxReadBlockSize, this.maxReadBlockRowCount, this.maxMergeDistance, this.maxBufferSize, this.useColumnIndex, useBatchColumnReaders, this.useBatchNestedColumnReaders, this.useBloomFilter);
    }

    public ParquetReaderOptions withBatchNestedColumnReaders(boolean useBatchNestedColumnReaders) {
        return new ParquetReaderOptions(this.ignoreStatistics, this.maxReadBlockSize, this.maxReadBlockRowCount, this.maxMergeDistance, this.maxBufferSize, this.useColumnIndex, this.useBatchColumnReaders, useBatchNestedColumnReaders, this.useBloomFilter);
    }

    public ParquetReaderOptions withBloomFilter(boolean useBloomFilter) {
        return new ParquetReaderOptions(this.ignoreStatistics, this.maxReadBlockSize, this.maxReadBlockRowCount, this.maxMergeDistance, this.maxBufferSize, this.useColumnIndex, this.useBatchColumnReaders, this.useBatchNestedColumnReaders, useBloomFilter);
    }
}

