/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.trino.parquet.Page;
import io.trino.parquet.ParquetEncoding;
import java.util.Objects;

public class DictionaryPage
extends Page {
    private final Slice slice;
    private final int dictionarySize;
    private final ParquetEncoding encoding;

    public DictionaryPage(Slice slice, int dictionarySize, ParquetEncoding encoding) {
        this(slice, slice.length(), dictionarySize, encoding);
    }

    public DictionaryPage(Slice slice, int uncompressedSize, int dictionarySize, ParquetEncoding encoding) {
        super(uncompressedSize);
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.dictionarySize = dictionarySize;
        this.encoding = Objects.requireNonNull(encoding, "encoding is null");
        Preconditions.checkArgument((encoding == ParquetEncoding.PLAIN_DICTIONARY || encoding == ParquetEncoding.PLAIN ? 1 : 0) != 0, (String)"Dictionary does not support encoding: %s", (Object)((Object)encoding));
    }

    public Slice getSlice() {
        return this.slice;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public ParquetEncoding getEncoding() {
        return this.encoding;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("slice", (Object)this.slice).add("dictionarySize", this.dictionarySize).add("encoding", (Object)this.encoding).add("uncompressedSize", this.uncompressedSize).toString();
    }
}

