/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel;

import com.google.common.base.Preconditions;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableCollection;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.common.functions.FunctionFieldReferenceOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveInOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveNamedStructFunction;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql2rel.ReflectiveConvertletTable;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.sql2rel.StandardConvertletTable;

public class HiveConvertletTable
extends ReflectiveConvertletTable {
    public RexNode convertNamedStruct(SqlRexContext cx, HiveNamedStructFunction func, SqlCall call) {
        ArrayList<RexNode> operandExpressions = new ArrayList<RexNode>(call.operandCount() / 2);
        for (int i = 0; i < call.operandCount(); i += 2) {
            operandExpressions.add(cx.convertExpression((SqlNode)call.operand(i + 1)));
        }
        RelDataType retType = cx.getValidator().getValidatedNodeType(call);
        RexNode rowNode = cx.getRexBuilder().makeCall(retType, SqlStdOperatorTable.ROW, operandExpressions);
        return cx.getRexBuilder().makeCast(retType, rowNode);
    }

    public RexNode convertHiveInOperator(SqlRexContext cx, HiveInOperator operator, SqlCall call) {
        List<SqlNode> operandList = call.getOperandList();
        Preconditions.checkState((operandList.size() == 2 && operandList.get(1) instanceof SqlNodeList ? 1 : 0) != 0);
        RexNode lhs = cx.convertExpression(operandList.get(0));
        SqlNodeList rhsNodes = (SqlNodeList)operandList.get(1);
        ImmutableCollection.ArrayBasedBuilder rexNodes = ImmutableList.builder().add(lhs);
        for (int i = 0; i < rhsNodes.size(); ++i) {
            ((ImmutableList.Builder)rexNodes).add(cx.convertExpression(rhsNodes.get(i)));
        }
        RelDataType retType = cx.getValidator().getValidatedNodeType(call);
        return cx.getRexBuilder().makeCall(retType, HiveInOperator.IN, (List<RexNode>)((Object)((ImmutableList.Builder)rexNodes).build()));
    }

    public RexNode convertFunctionFieldReferenceOperator(SqlRexContext cx, FunctionFieldReferenceOperator op, SqlCall call) {
        RexNode funcExpr = cx.convertExpression((SqlNode)call.operand(0));
        String fieldName = FunctionFieldReferenceOperator.fieldNameStripQuotes(call.operand(1));
        return cx.getRexBuilder().makeFieldAccess(funcExpr, fieldName, false);
    }

    public RexNode convertCast(SqlRexContext cx, SqlCastFunction cast, SqlCall call) {
        Object left = call.operand(0);
        RexNode leftRex = cx.convertExpression((SqlNode)left);
        SqlDataTypeSpec dataType = (SqlDataTypeSpec)call.operand(1);
        RelDataType castType = dataType.deriveType(cx.getValidator(), true);
        return cx.getRexBuilder().makeAbstractCast(castType, leftRex);
    }

    @Override
    public SqlRexConvertlet get(SqlCall call) {
        SqlRexConvertlet convertlet = super.get(call);
        return convertlet != null ? convertlet : StandardConvertletTable.INSTANCE.get(call);
    }
}

