/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common.utils;

import java.util.ArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.MapSqlType;

public class RelDataTypeToHiveTypeStringConverter {
    private RelDataTypeToHiveTypeStringConverter() {
    }

    public static String convertRelDataType(RelDataType relDataType) {
        switch (relDataType.getSqlTypeName()) {
            case ROW: {
                return RelDataTypeToHiveTypeStringConverter.buildStructDataTypeString((RelRecordType)relDataType);
            }
            case ARRAY: {
                return RelDataTypeToHiveTypeStringConverter.buildArrayDataTypeString((ArraySqlType)relDataType);
            }
            case MAP: {
                return RelDataTypeToHiveTypeStringConverter.buildMapDataTypeString((MapSqlType)relDataType);
            }
            case INTEGER: {
                return "int";
            }
            case SMALLINT: {
                return "smallint";
            }
            case TINYINT: {
                return "tinyint";
            }
            case BIGINT: {
                return "bigint";
            }
            case DOUBLE: {
                return "double";
            }
            case REAL: 
            case FLOAT: {
                return "float";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case CHAR: 
            case VARCHAR: {
                return "string";
            }
            case DATE: {
                return "date";
            }
            case TIME: 
            case TIMESTAMP: {
                return "timestamp";
            }
            case BINARY: 
            case VARBINARY: 
            case OTHER: {
                return "binary";
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: {
                return "interval";
            }
            case NULL: {
                return "null";
            }
        }
        throw new RuntimeException(String.format("Unhandled RelDataType %s in Converter from RelDataType to Hive DataType", new Object[]{relDataType.getSqlTypeName()}));
    }

    private static String buildStructDataTypeString(RelRecordType relRecordType) {
        ArrayList<String> structFieldStrings = new ArrayList<String>();
        for (RelDataTypeField fieldRelDataType : relRecordType.getFieldList()) {
            structFieldStrings.add(String.format("%s:%s", fieldRelDataType.getName(), RelDataTypeToHiveTypeStringConverter.convertRelDataType(fieldRelDataType.getType())));
        }
        String subFieldsString = String.join((CharSequence)",", structFieldStrings);
        return String.format("struct<%s>", subFieldsString);
    }

    private static String buildArrayDataTypeString(ArraySqlType arraySqlType) {
        String elementDataTypeString = RelDataTypeToHiveTypeStringConverter.convertRelDataType(arraySqlType.getComponentType());
        return String.format("array<%s>", elementDataTypeString);
    }

    private static String buildMapDataTypeString(MapSqlType mapSqlType) {
        String keyDataTypeString = RelDataTypeToHiveTypeStringConverter.convertRelDataType(mapSqlType.getKeyType());
        String valueDataTypeString = RelDataTypeToHiveTypeStringConverter.convertRelDataType(mapSqlType.getValueType());
        return String.format("map<%s,%s>", keyDataTypeString, valueDataTypeString);
    }
}

