/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple;

import com.linkedin.coral.calcite.$internal.com.yahoo.memory.Memory;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.hash.MurmurHash3;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.ArrayOfDoublesCompactSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.ArrayOfDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.DirectArrayOfDoublesCompactSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.HeapArrayOfDoublesCompactSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.Util;

public abstract class ArrayOfDoublesUpdatableSketch
extends ArrayOfDoublesSketch {
    final long seed_;

    ArrayOfDoublesUpdatableSketch(int numValues, long seed) {
        super(numValues);
        this.seed_ = seed;
    }

    public void update(long key, double[] values) {
        this.update(new long[]{key}, values);
    }

    public void update(double key, double[] values) {
        this.update(Util.doubleToLongArray(key), values);
    }

    public void update(String key, double[] values) {
        this.update(Util.stringToByteArray(key), values);
    }

    public void update(byte[] key, double[] values) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values);
    }

    public void update(int[] key, double[] values) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values);
    }

    public void update(long[] key, double[] values) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values);
    }

    public abstract int getNominalEntries();

    public abstract void trim();

    public ArrayOfDoublesCompactSketch compact() {
        return this.compact(null);
    }

    public ArrayOfDoublesCompactSketch compact(Memory dstMem) {
        if (dstMem == null) {
            return new HeapArrayOfDoublesCompactSketch(this);
        }
        return new DirectArrayOfDoublesCompactSketch(this, dstMem);
    }

    long getSeed() {
        return this.seed_;
    }

    @Override
    short getSeedHash() {
        return Util.computeSeedHash(this.seed_);
    }

    abstract void insertOrIgnore(long var1, double[] var3);
}

