/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles;

import com.linkedin.coral.calcite.$internal.com.yahoo.memory.Memory;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.Family;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.SketchesArgumentException;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.CompactDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DirectUpdateDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesUtil;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.PreambleUtil;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.Util;

final class DirectCompactDoublesSketch
extends CompactDoublesSketch {
    private static final int MIN_DIRECT_DOUBLES_SER_VER = 3;
    private Memory mem_;

    private DirectCompactDoublesSketch(int k) {
        super(k);
    }

    static DirectCompactDoublesSketch createFromUpdateSketch(UpdateDoublesSketch sketch, Memory dstMem) {
        long memCap = dstMem.getCapacity();
        int k = sketch.getK();
        long n = sketch.getN();
        DirectCompactDoublesSketch.checkDirectMemCapacity(k, n, memCap);
        Object memObj = dstMem.array();
        long memAdd = dstMem.getCumulativeOffset(0L);
        dstMem.putLong(0L, 0L);
        PreambleUtil.insertPreLongs(memObj, memAdd, 2);
        PreambleUtil.insertSerVer(memObj, memAdd, 3);
        PreambleUtil.insertFamilyID(memObj, memAdd, Family.QUANTILES.getID());
        PreambleUtil.insertK(memObj, memAdd, k);
        int flags = 10;
        if (sketch.isEmpty()) {
            PreambleUtil.insertFlags(memObj, memAdd, 14);
        } else {
            PreambleUtil.insertFlags(memObj, memAdd, 10);
            PreambleUtil.insertN(memObj, memAdd, n);
            PreambleUtil.insertMinDouble(memObj, memAdd, sketch.getMinValue());
            PreambleUtil.insertMaxDouble(memObj, memAdd, sketch.getMaxValue());
            int bbCount = Util.computeBaseBufferItems(k, n);
            DoublesSketchAccessor inputAccessor = DoublesSketchAccessor.wrap(sketch);
            assert (bbCount == inputAccessor.numItems());
            long dstMemOffset = 32L;
            dstMem.putDoubleArray(dstMemOffset, inputAccessor.getArray(0, bbCount), 0, bbCount);
            dstMemOffset += (long)(bbCount << 3);
            int lvl = 0;
            for (long bitPattern = Util.computeBitPattern(k, n); bitPattern > 0L; bitPattern >>>= 1) {
                if ((bitPattern & 1L) > 0L) {
                    inputAccessor.setLevel(lvl);
                    dstMem.putDoubleArray(dstMemOffset, inputAccessor.getArray(0, k), 0, k);
                    dstMemOffset += (long)(k << 3);
                }
                ++lvl;
            }
        }
        DirectCompactDoublesSketch dcds = new DirectCompactDoublesSketch(k);
        dcds.mem_ = dstMem;
        return dcds;
    }

    static DirectCompactDoublesSketch wrapInstance(Memory srcMem) {
        long n;
        boolean empty;
        int k;
        int flags;
        int familyID;
        int serVer;
        int preLongs;
        long memCap = srcMem.getCapacity();
        if (srcMem.isReadOnly() && !srcMem.isDirect()) {
            preLongs = srcMem.getByte(0L) & 0xFF;
            serVer = srcMem.getByte(1L) & 0xFF;
            familyID = srcMem.getByte(2L) & 0xFF;
            flags = srcMem.getByte(3L) & 0xFF;
            k = srcMem.getShort(4L) & 0xFFFF;
            empty = (flags & 4) > 0;
            n = empty ? 0L : srcMem.getLong(8L);
        } else {
            Object memObj = srcMem.array();
            long memAdd = srcMem.getCumulativeOffset(0L);
            preLongs = PreambleUtil.extractPreLongs(memObj, memAdd);
            serVer = PreambleUtil.extractSerVer(memObj, memAdd);
            familyID = PreambleUtil.extractFamilyID(memObj, memAdd);
            flags = PreambleUtil.extractFlags(memObj, memAdd);
            k = PreambleUtil.extractK(memObj, memAdd);
            empty = (flags & 4) > 0;
            n = empty ? 0L : PreambleUtil.extractN(memObj, memAdd);
        }
        DirectUpdateDoublesSketch.checkPreLongs(preLongs);
        Util.checkFamilyID(familyID);
        DoublesUtil.checkDoublesSerVer(serVer, 3);
        DirectCompactDoublesSketch.checkCompact(serVer, flags);
        Util.checkK(k);
        DirectCompactDoublesSketch.checkDirectMemCapacity(k, n, memCap);
        DirectUpdateDoublesSketch.checkEmptyAndN(empty, n);
        DirectCompactDoublesSketch dds = new DirectCompactDoublesSketch(k);
        dds.mem_ = srcMem;
        return dds;
    }

    @Override
    public long getN() {
        if (this.mem_.getCapacity() < 32L) {
            return 0L;
        }
        return this.mem_.getLong(8L);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public double getMinValue() {
        if (this.mem_.getCapacity() < 32L) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mem_.getDouble(16L);
    }

    @Override
    public double getMaxValue() {
        if (this.mem_.getCapacity() < 32L) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.mem_.getDouble(24L);
    }

    @Override
    int getBaseBufferCount() {
        return Util.computeBaseBufferItems(this.getK(), this.getN());
    }

    @Override
    int getCombinedBufferItemCapacity() {
        return ((int)this.mem_.getCapacity() - 32) / 8;
    }

    @Override
    double[] getCombinedBuffer() {
        int k = this.getK();
        if (this.isEmpty()) {
            return new double[k << 1];
        }
        long n = this.getN();
        int itemCap = Util.computeRetainedItems(k, n);
        double[] combinedBuffer = new double[itemCap];
        this.mem_.getDoubleArray(32L, combinedBuffer, 0, itemCap);
        return combinedBuffer;
    }

    @Override
    long getBitPattern() {
        int k = this.getK();
        long n = this.getN();
        return Util.computeBitPattern(k, n);
    }

    @Override
    Memory getMemory() {
        return this.mem_;
    }

    static void checkDirectMemCapacity(int k, long n, long memCapBytes) {
        int reqBufBytes = DirectCompactDoublesSketch.getCompactStorageBytes(k, n);
        if (memCapBytes < (long)reqBufBytes) {
            throw new SketchesArgumentException("Possible corruption: Memory capacity too small: " + memCapBytes + " < " + reqBufBytes);
        }
    }

    static void checkCompact(int serVer, int flags) {
        int compactFlagMask = 24;
        if (serVer != 2 && (flags & 4) == 0 && (flags & 0x18) != 24) {
            throw new SketchesArgumentException("Possible corruption: Must be v2, empty, or compact and ordered. Flags field: " + Integer.toBinaryString(flags) + ", SerVer: " + serVer);
        }
    }
}

