/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.base.MoreObjects;
import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Identifier;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import com.linkedin.coral.$internal.io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Use
extends Statement {
    private final Optional<Identifier> catalog;
    private final Identifier schema;

    public Use(Optional<Identifier> catalog, Identifier schema) {
        this(Optional.empty(), catalog, schema);
    }

    public Use(NodeLocation location, Optional<Identifier> catalog, Identifier schema) {
        this(Optional.of(location), catalog, schema);
    }

    private Use(Optional<NodeLocation> location, Optional<Identifier> catalog, Identifier schema) {
        super(location);
        Objects.requireNonNull(catalog, "catalog is null");
        Objects.requireNonNull(schema, "schema is null");
        this.catalog = catalog;
        this.schema = schema;
    }

    public Optional<Identifier> getCatalog() {
        return this.catalog;
    }

    public Identifier getSchema() {
        return this.schema;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUse(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalog, this.schema);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Use use = (Use)o;
        if (!this.catalog.equals(use.catalog)) {
            return false;
        }
        return this.schema.equals(use.schema);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).toString();
    }
}

