/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.base.MoreObjects;
import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import com.linkedin.coral.$internal.io.trino.sql.tree.TransactionMode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class TransactionAccessMode
extends TransactionMode {
    private final boolean readOnly;

    public TransactionAccessMode(boolean readOnly) {
        this(Optional.empty(), readOnly);
    }

    public TransactionAccessMode(NodeLocation location, boolean readOnly) {
        this(Optional.of(location), readOnly);
    }

    private TransactionAccessMode(Optional<NodeLocation> location, boolean readOnly) {
        super(location);
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTransactionAccessMode(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.readOnly);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionAccessMode other = (TransactionAccessMode)obj;
        return this.readOnly == other.readOnly;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("readOnly", this.readOnly).toString();
    }
}

