/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.manager;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.MapBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemModule;
import io.trino.filesystem.manager.FileSystemConfig;
import io.trino.filesystem.manager.SwitchingFileSystemFactory;
import io.trino.filesystem.s3.S3FileSystemFactory;
import io.trino.filesystem.s3.S3FileSystemModule;
import io.trino.filesystem.tracing.TracingFileSystemFactory;
import io.trino.hdfs.s3.HiveS3Module;
import java.util.Map;
import java.util.Optional;

public class FileSystemModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        FileSystemConfig config = (FileSystemConfig)this.buildConfigObject(FileSystemConfig.class);
        binder.bind(HdfsFileSystemFactoryHolder.class).in(Scopes.SINGLETON);
        if (config.isHadoopEnabled()) {
            this.install((Module)new HdfsFileSystemModule());
        }
        MapBinder factories = MapBinder.newMapBinder((Binder)binder, String.class, TrinoFileSystemFactory.class);
        if (config.isNativeS3Enabled()) {
            this.install((Module)new S3FileSystemModule());
            factories.addBinding((Object)"s3").to(S3FileSystemFactory.class);
            factories.addBinding((Object)"s3a").to(S3FileSystemFactory.class);
            factories.addBinding((Object)"s3n").to(S3FileSystemFactory.class);
        } else {
            this.install((Module)new HiveS3Module());
        }
    }

    @Provides
    @Singleton
    public TrinoFileSystemFactory createFileSystemFactory(HdfsFileSystemFactoryHolder hdfsFileSystemFactory, Map<String, TrinoFileSystemFactory> factories, Tracer tracer) {
        SwitchingFileSystemFactory delegate = new SwitchingFileSystemFactory(hdfsFileSystemFactory.value(), factories);
        return new TracingFileSystemFactory(tracer, (TrinoFileSystemFactory)delegate);
    }

    public static class HdfsFileSystemFactoryHolder {
        @Inject(optional=true)
        private HdfsFileSystemFactory hdfsFileSystemFactory;

        public Optional<TrinoFileSystemFactory> value() {
            return Optional.ofNullable(this.hdfsFileSystemFactory);
        }
    }
}

