/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jdbi.v3.meta.Beta;

@Beta
public final class Sql
implements CharSequence {
    private static final Sql EMPTY_SQL = new Sql("");
    private final String str;

    private Sql(String sql) {
        this.str = sql;
    }

    public static Sql of(CharSequence ... tokens) {
        return tokens == null ? EMPTY_SQL : Sql.of(Arrays.asList(tokens));
    }

    public static Sql of(Iterable<? extends CharSequence> tokens) {
        return tokens == null ? EMPTY_SQL : new Sql(Sql.format(tokens));
    }

    static String format(Iterable<? extends CharSequence> tokens) {
        String sql = StreamSupport.stream(Objects.requireNonNull(tokens).spliterator(), false).filter(Objects::nonNull).map(CharSequence::toString).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.joining(" "));
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql;
    }

    @Override
    public int length() {
        return this.str.length();
    }

    @Override
    public char charAt(int index) {
        return this.str.charAt(index);
    }

    @Override
    @NonNull
    public CharSequence subSequence(int start, int end) {
        return this.str.subSequence(start, end);
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.str.equals(((Sql)obj).str);
    }

    @Override
    public String toString() {
        return this.str;
    }
}

