/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.cache.query.index.IndexProcessor;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.DateValueUtils;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.Hasher;
import org.apache.ignite.internal.processors.query.stat.StatisticsUtils;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnOverrides;
import org.apache.ignite.internal.processors.query.stat.hll.HLL;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ColumnStatisticsCollector {
    private static final Set<Class<?>> comparableCls = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, BigDecimal.class, Double.class, Float.class, Time.class, Timestamp.class, java.util.Date.class, Date.class, LocalTime.class, LocalDate.class, LocalDateTime.class, UUID.class));
    private final String colName;
    private final int colId;
    private final HLL hll = ColumnStatisticsCollector.buildHll();
    private BigDecimal min;
    private BigDecimal max;
    private long total;
    private long size;
    private long nullsCnt;
    private final boolean isComparable;
    private final Hasher hash = new Hasher();
    private final long ver;
    private final Class<?> colType;

    public ColumnStatisticsCollector(int colId, String colName, Class<?> colType) {
        this(colId, colName, colType, 0L);
    }

    public ColumnStatisticsCollector(int colId, String colName, Class<?> colType, long ver) {
        this.colId = colId;
        this.colName = colName;
        this.ver = ver;
        this.colType = colType;
        this.isComparable = colType != null && comparableCls.contains(colType);
    }

    public void add(Object val) throws IgniteCheckedException {
        ++this.total;
        if (val == null) {
            ++this.nullsCnt;
            return;
        }
        this.addToHll(val);
        if (this.isComparable) {
            BigDecimal decVal = StatisticsUtils.toDecimal(val);
            if (null == this.min || this.min.compareTo(decVal) > 0) {
                this.min = decVal;
            }
            if (null == this.max || this.max.compareTo(decVal) < 0) {
                this.max = decVal;
            }
        }
    }

    public ColumnStatistics finish() {
        int averageSize = ColumnStatisticsCollector.averageSize(this.size, this.total, this.nullsCnt);
        return new ColumnStatistics(StatisticsUtils.toDecimal(this.min), StatisticsUtils.toDecimal(this.max), this.nullsCnt, this.hll.cardinality(), this.total, averageSize, this.hll.toBytes(), this.ver, U.currentTimeMillis());
    }

    private static int averageSize(long size, long total, long nullsCnt) {
        long averageSizeLong = total - nullsCnt > 0L ? size / (total - nullsCnt) : 0L;
        return averageSizeLong > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)averageSizeLong;
    }

    public int columnId() {
        return this.colId;
    }

    public String columnName() {
        return this.colName;
    }

    public Class<?> columnType() {
        return this.colType;
    }

    public static ColumnStatistics aggregate(List<ColumnStatistics> partStats, StatisticsColumnOverrides overrides) {
        assert (!F.isEmpty(partStats));
        Long overrideDistinct = overrides == null ? null : overrides.distinct();
        HLL hll = ColumnStatisticsCollector.buildHll();
        BigDecimal min = null;
        BigDecimal max = null;
        long nullsCnt = 0L;
        long total = 0L;
        long totalSize = 0L;
        ColumnStatistics firstStat = F.first(partStats);
        long ver = firstStat.version();
        long createdAt = firstStat.createdAt();
        for (ColumnStatistics partStat : partStats) {
            assert (ver == partStat.version()) : "Aggregate statistics with different version [stats=" + partStats + ']';
            if (overrideDistinct == null) {
                HLL partHll = HLL.fromBytes(partStat.raw());
                hll.union(partHll);
            }
            total += partStat.total();
            nullsCnt += partStat.nulls();
            totalSize += (long)partStat.size() * (partStat.total() - partStat.nulls());
            if (min == null || partStat.min() != null && partStat.min().compareTo(min) < 0) {
                min = partStat.min();
            }
            if (max == null || partStat.max() != null && partStat.max().compareTo(max) > 0) {
                max = partStat.max();
            }
            if (createdAt >= partStat.createdAt()) continue;
            createdAt = partStat.createdAt();
        }
        Integer overrideSize = overrides == null ? null : overrides.size();
        int averageSize = overrideSize == null ? ColumnStatisticsCollector.averageSize(totalSize, total, nullsCnt) : overrideSize;
        long distinct = overrideDistinct == null ? hll.cardinality() : overrideDistinct.longValue();
        Long overrideNulls = overrides == null ? null : overrides.nulls();
        long nulls = overrideNulls == null ? nullsCnt : overrideNulls;
        Long overrideTotal = overrides == null ? null : overrides.total();
        total = overrideTotal == null ? total : overrideTotal;
        return new ColumnStatistics(min, max, nulls, distinct, total, averageSize, hll.toBytes(), ver, createdAt);
    }

    private static HLL buildHll() {
        return new HLL(13, 5);
    }

    private void addToHll(Object obj) {
        byte[] buf;
        assert (obj != null);
        Class<Object> cls = U.box(obj.getClass());
        if (Boolean.class.isAssignableFrom(cls)) {
            buf = new byte[]{(Boolean)obj != false ? (byte)1 : 0};
        } else if (Byte.class.isAssignableFrom(cls)) {
            buf = new byte[]{(Byte)obj};
        } else if (Short.class.isAssignableFrom(cls)) {
            buf = U.shortToBytes((Short)obj);
        } else if (Integer.class.isAssignableFrom(cls)) {
            buf = U.intToBytes((Integer)obj);
        } else if (Long.class.isAssignableFrom(cls)) {
            buf = U.longToBytes((Long)obj);
        } else if (Float.class.isAssignableFrom(cls)) {
            buf = U.intToBytes(Float.floatToIntBits(((Float)obj).floatValue()));
        } else if (Double.class.isAssignableFrom(cls)) {
            buf = U.longToBytes(Double.doubleToLongBits((Double)obj));
        } else if (BigDecimal.class.isAssignableFrom(cls)) {
            BigInteger unscaledVal = ((BigDecimal)obj).unscaledValue();
            int scale = ((BigDecimal)obj).scale();
            buf = U.join(unscaledVal.toByteArray(), U.intToBytes(scale));
        } else if (UUID.class.isAssignableFrom(cls)) {
            buf = U.uuidToBytes((UUID)obj);
        } else if (LocalDate.class.isAssignableFrom(cls)) {
            buf = U.longToBytes(DateValueUtils.convertToSqlDate((LocalDate)obj).getTime());
        } else if (LocalTime.class.isAssignableFrom(cls)) {
            buf = U.longToBytes(DateValueUtils.convertToSqlTime((LocalTime)obj).getTime());
        } else if (LocalDateTime.class.isAssignableFrom(cls)) {
            buf = ColumnStatisticsCollector.timestampToBytes(DateValueUtils.convertToTimestamp((LocalDateTime)obj));
        } else if (Timestamp.class.isAssignableFrom(cls)) {
            buf = ColumnStatisticsCollector.timestampToBytes((Timestamp)obj);
        } else if (java.util.Date.class.isAssignableFrom(cls)) {
            buf = U.longToBytes(((java.util.Date)obj).getTime());
        } else if (cls.isAssignableFrom(byte[].class)) {
            buf = (byte[])obj;
        } else if (cls.isAssignableFrom(String.class)) {
            buf = ((String)obj).getBytes(StandardCharsets.UTF_8);
        } else if (obj instanceof BinaryObjectImpl) {
            buf = ((BinaryObjectImpl)obj).array();
        } else {
            try {
                buf = IndexProcessor.serializer.serialize(obj);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
        this.size += (long)buf.length;
        this.hll.addRaw(this.hash.fastHash(buf));
    }

    private static byte[] timestampToBytes(Timestamp ts) {
        byte[] buf = new byte[12];
        U.longToBytes(ts.getTime(), buf, 0);
        U.intToBytes(ts.getNanos(), buf, 8);
        return buf;
    }
}

