/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.S;

public class SegmentedRingByteBuffer {
    private static final long OPEN_MASK = Long.MAX_VALUE;
    private static final long CLOSE_MASK = Long.MIN_VALUE;
    private static final AtomicLongFieldUpdater<SegmentedRingByteBuffer> TAIL_UPD = AtomicLongFieldUpdater.newUpdater(SegmentedRingByteBuffer.class, "tail");
    private static final AtomicIntegerFieldUpdater<SegmentedRingByteBuffer> PRODUCERS_CNT_UPD = AtomicIntegerFieldUpdater.newUpdater(SegmentedRingByteBuffer.class, "producersCnt");
    private final int cap;
    private final BufferMode mode;
    public final ByteBuffer buf;
    private final long maxSegmentSize;
    private volatile long head;
    private volatile long tail;
    private volatile int producersCnt;
    private volatile boolean waitForConsumer;
    private final DataStorageMetricsImpl metrics;

    public SegmentedRingByteBuffer(int cap, long maxSegmentSize, BufferMode mode) {
        this(cap, maxSegmentSize, mode == BufferMode.DIRECT ? ByteBuffer.allocateDirect(cap) : ByteBuffer.allocate(cap), mode, null);
    }

    public SegmentedRingByteBuffer(int cap, long maxSegmentSize, BufferMode mode, DataStorageMetricsImpl metrics) {
        this(cap, maxSegmentSize, mode == BufferMode.DIRECT ? ByteBuffer.allocateDirect(cap) : ByteBuffer.allocate(cap), mode, metrics);
    }

    public SegmentedRingByteBuffer(MappedByteBuffer buf, DataStorageMetricsImpl metrics) {
        this(buf.capacity(), buf.capacity(), buf, BufferMode.MAPPED, metrics);
    }

    private SegmentedRingByteBuffer(int cap, long maxSegmentSize, ByteBuffer buf, BufferMode mode, DataStorageMetricsImpl metrics) {
        this.cap = cap;
        this.mode = mode;
        this.buf = buf;
        this.buf.order(ByteOrder.nativeOrder());
        this.maxSegmentSize = maxSegmentSize;
        this.metrics = metrics;
    }

    public void init(long pos) {
        this.head = pos;
        this.tail = pos;
    }

    public BufferMode mode() {
        return this.mode;
    }

    public long tail() {
        return this.tail & Long.MAX_VALUE;
    }

    public WriteSegment offer(int size) {
        return this.offer0(size, false);
    }

    public WriteSegment offerSafe(int size) {
        return this.offer0(size, true);
    }

    private WriteSegment offer0(int size, boolean safe) {
        boolean wrap;
        long newTail;
        boolean fitsSeg;
        long currTailIdx;
        long currTail;
        boolean upd;
        int cur;
        if (size > this.cap) {
            throw new IgniteException("Record is too long [capacity=" + this.cap + ", size=" + size + ']');
        }
        while (this.waitForConsumer || (cur = this.producersCnt) < 0 || !PRODUCERS_CNT_UPD.compareAndSet(this, cur, cur + 1)) {
        }
        do {
            currTail = this.tail;
            assert (!safe || currTail < 0L) : "Unsafe usage of segment ring byte buffer currTail=" + currTail;
            if (currTail < 0L) {
                if (safe) {
                    currTail &= Long.MAX_VALUE;
                } else {
                    return new WriteSegment(null, -1L);
                }
            }
            long head0 = this.head;
            currTailIdx = this.toIndex(currTail);
            fitsSeg = currTail + (long)size <= this.maxSegmentSize;
            long l = newTail = fitsSeg ? currTail + (long)size : currTail;
            if (head0 < newTail - (long)this.cap) {
                PRODUCERS_CNT_UPD.decrementAndGet(this);
                return null;
            }
            long tail0 = fitsSeg ? (safe ? newTail | Long.MIN_VALUE : newTail) : newTail | Long.MIN_VALUE;
            upd = TAIL_UPD.compareAndSet(this, safe ? currTail | Long.MIN_VALUE : currTail, tail0);
            assert (!safe || upd) : "Unsafe usage of segment ring byte buffer";
        } while (!upd);
        if (!fitsSeg) {
            return new WriteSegment(null, -1L);
        }
        boolean bl = wrap = (long)this.cap - currTailIdx < (long)size;
        if (wrap) {
            long newTailIdx = this.toIndex(newTail);
            return new WriteSegment(currTail, newTail, newTailIdx == 0L ? newTail : currTail);
        }
        ByteBuffer slice = this.slice((int)this.toIndex(newTail - (long)size), size, false);
        return new WriteSegment(slice, newTail);
    }

    public void close() {
        long currTail;
        do {
            if ((currTail = this.tail) >= 0L) continue;
            return;
        } while (!TAIL_UPD.compareAndSet(this, currTail, currTail | Long.MIN_VALUE));
    }

    public List<ReadSegment> poll() {
        return this.poll(-1L);
    }

    public List<ReadSegment> poll(long pos) {
        boolean wrapped;
        this.waitForConsumer = true;
        int spins = 0;
        while (!PRODUCERS_CNT_UPD.compareAndSet(this, 0, -1)) {
            ++spins;
        }
        if (this.metrics != null && this.metrics.metricsEnabled()) {
            this.metrics.onBuffPollSpin(spins);
        }
        long head = this.head;
        long tail = this.tail & Long.MAX_VALUE;
        this.producersCnt = 0;
        this.waitForConsumer = false;
        if (tail <= head || pos >= 0L && head > pos) {
            return null;
        }
        int headIdx = (int)this.toIndex(head);
        int tailIdx = (int)this.toIndex(tail);
        boolean bl = wrapped = tailIdx <= headIdx;
        if (wrapped && tailIdx != 0) {
            ArrayList<ReadSegment> lst = new ArrayList<ReadSegment>(2);
            int lim = this.cap - headIdx;
            lst.add(new ReadSegment(this.slice(headIdx, lim, true), head, head + (long)lim));
            lst.add(new ReadSegment(this.slice(0, tailIdx, true), head + (long)lim, tail));
            return lst;
        }
        return Collections.singletonList(new ReadSegment(this.slice(headIdx, (int)(tail - head), true), head, tail));
    }

    public void free() {
        if (this.mode == BufferMode.DIRECT || this.mode == BufferMode.MAPPED) {
            GridUnsafe.cleanDirectBuffer(this.buf);
        }
    }

    public SegmentedRingByteBuffer reset() {
        return new SegmentedRingByteBuffer(this.buf.capacity(), this.maxSegmentSize, this.buf, this.mode, this.metrics);
    }

    private ByteBuffer slice(int off, int len, boolean readOnly) {
        ByteBuffer bb = readOnly ? this.buf.asReadOnlyBuffer() : this.buf.duplicate();
        bb.order(ByteOrder.nativeOrder());
        bb.limit(off + len);
        bb.position(off);
        return bb;
    }

    private long toIndex(long globalIdx) {
        return globalIdx % (long)this.cap;
    }

    private void copy(ByteBuffer src, int srcPos, ByteBuffer dest, int destPos, int len) {
        assert (this.mode != BufferMode.MAPPED);
        if (this.buf.isDirect()) {
            ByteBuffer src0 = src.duplicate();
            src0.limit(srcPos + len);
            src0.position(srcPos);
            ByteBuffer dest0 = dest.duplicate();
            dest0.limit(destPos + len);
            dest0.position(destPos);
            dest0.put(src0);
        } else {
            System.arraycopy(src.array(), srcPos, this.buf.array(), destPos, len);
        }
    }

    public static enum BufferMode {
        ONHEAP,
        DIRECT,
        MAPPED;

    }

    public class ReadSegment
    extends Segment {
        private final long newHead;

        private ReadSegment(ByteBuffer seg, long pos, long newHead) {
            super(seg, pos);
            this.newHead = newHead;
        }

        @Override
        public void release() {
            if (this.newHead >= 0L) {
                SegmentedRingByteBuffer.this.head = this.newHead;
            }
        }

        @Override
        public ByteBuffer buffer() {
            return this.seg;
        }

        @Override
        public String toString() {
            return S.toString(ReadSegment.class, this, "super", (Object)super.toString());
        }
    }

    public class WriteSegment
    extends Segment {
        private final long currTail;
        private final long wrapPnt;

        private WriteSegment(long currTail, long newTail, long wrapPnt) {
            super(ByteBuffer.allocate((int)(newTail - currTail)), newTail);
            this.seg.order(ByteOrder.nativeOrder());
            this.currTail = currTail;
            this.wrapPnt = wrapPnt;
        }

        private WriteSegment(ByteBuffer seg, long pos) {
            super(seg, pos);
            this.currTail = -1L;
            this.wrapPnt = -1L;
        }

        @Override
        public ByteBuffer buffer() {
            return this.seg;
        }

        @Override
        public void release() {
            if (this.wrapPnt > -1L) {
                int pos = (int)SegmentedRingByteBuffer.this.toIndex(this.currTail);
                int len = SegmentedRingByteBuffer.this.cap - pos;
                SegmentedRingByteBuffer.this.copy(this.seg, 0, SegmentedRingByteBuffer.this.buf, pos, len);
                SegmentedRingByteBuffer.this.copy(this.seg, len, SegmentedRingByteBuffer.this.buf, 0, this.seg.array().length - len);
            }
            assert (SegmentedRingByteBuffer.this.producersCnt >= 0);
            PRODUCERS_CNT_UPD.decrementAndGet(SegmentedRingByteBuffer.this);
        }

        @Override
        public String toString() {
            return S.toString(WriteSegment.class, this, "super", (Object)super.toString());
        }
    }

    private abstract class Segment {
        protected final ByteBuffer seg;
        protected final long pos;

        protected Segment(ByteBuffer seg, long pos) {
            this.seg = seg;
            this.pos = pos;
        }

        public abstract void release();

        public abstract ByteBuffer buffer();

        public long position() {
            return this.pos;
        }

        public String toString() {
            return S.toString(Segment.class, this);
        }
    }
}

