/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.GridLocalConfigManager;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.CacheStripedExecutor;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FileVersionCheckingFactory;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.AbstractSnapshotVerificationTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IncrementalSnapshotProcessor;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperationRequest;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.util.distributed.DistributedProcess;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class SnapshotRestoreProcess {
    public static final String TMP_CACHE_DIR_PREFIX = "_tmp_snp_restore_";
    public static final String SNAPSHOT_RESTORE_METRICS = "snapshot-restore";
    private static final String OP_REJECT_MSG = "Cache group restore operation was rejected. ";
    private static final String OP_FINISHED_MSG = "Cache groups have been successfully restored from the snapshot";
    private static final String OP_FAILED_MSG = "Failed to restore snapshot cache groups";
    private final GridKernalContext ctx;
    private final DistributedProcess<SnapshotOperationRequest, SnapshotRestoreOperationResponse> prepareRestoreProc;
    private final DistributedProcess<UUID, Boolean> preloadProc;
    private final DistributedProcess<UUID, Boolean> cacheStartProc;
    private final DistributedProcess<UUID, Boolean> cacheStopProc;
    private final DistributedProcess<UUID, Boolean> incSnpRestoreProc;
    private final DistributedProcess<UUID, Boolean> rollbackRestoreProc;
    private final IgniteLogger log;
    private final ThreadLocal<ByteBuffer> locBuff;
    private volatile IgniteSnapshotManager.ClusterSnapshotFuture fut;
    private volatile SnapshotRestoreContext opCtx;
    private volatile SnapshotRestoreContext lastOpCtx = new SnapshotRestoreContext();

    public SnapshotRestoreProcess(GridKernalContext ctx, ThreadLocal<ByteBuffer> locBuff) {
        this.ctx = ctx;
        this.log = ctx.log(this.getClass());
        this.locBuff = locBuff;
        this.prepareRestoreProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.RESTORE_CACHE_GROUP_SNAPSHOT_PREPARE, this::prepare, this::finishPrepare);
        this.preloadProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.RESTORE_CACHE_GROUP_SNAPSHOT_PRELOAD, this::preload, this::finishPreload);
        this.cacheStartProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.RESTORE_CACHE_GROUP_SNAPSHOT_START, this::cacheStart, this::finishCacheStart);
        this.cacheStopProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.RESTORE_CACHE_GROUP_SNAPSHOT_STOP, this::cacheStop, this::finishCacheStop);
        this.incSnpRestoreProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.RESTORE_INCREMENTAL_SNAPSHOT_START, this::incrementalSnapshotRestore, this::finishIncrementalSnapshotRestore);
        this.rollbackRestoreProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.RESTORE_CACHE_GROUP_SNAPSHOT_ROLLBACK, this::rollback, this::finishRollback);
    }

    protected void cleanup() throws IgniteCheckedException {
        FilePageStoreManager pageStore = (FilePageStoreManager)this.ctx.cache().context().pageStore();
        File dbDir = pageStore.workDir();
        for (File dir2 : dbDir.listFiles(dir -> dir.isDirectory() && dir.getName().startsWith(TMP_CACHE_DIR_PREFIX))) {
            if (U.delete(dir2)) continue;
            throw new IgniteCheckedException("Unable to remove temporary directory, try deleting it manually [dir=" + dir2 + ']');
        }
    }

    protected void registerMetrics() {
        assert (!this.ctx.clientNode());
        MetricRegistry mreg = this.ctx.metric().registry(SNAPSHOT_RESTORE_METRICS);
        mreg.register("startTime", () -> this.lastOpCtx.startTime, "The system time of the start of the cluster snapshot restore operation on this node.");
        mreg.register("endTime", () -> this.lastOpCtx.endTime, "The system time when the restore operation of a cluster snapshot on this node ended.");
        mreg.register("snapshotName", () -> this.lastOpCtx.snpName, String.class, "The snapshot name of the last running cluster snapshot restore operation on this node.");
        mreg.register("incrementIndex", () -> this.lastOpCtx.incIdx, "The index of incremental snapshot of the last snapshot restore operation on this node.");
        mreg.register("requestId", () -> Optional.ofNullable(this.lastOpCtx.reqId).map(UUID::toString).orElse(""), String.class, "The request ID of the last running cluster snapshot restore operation on this node.");
        mreg.register("error", () -> Optional.ofNullable(this.lastOpCtx.err.get()).map(Throwable::toString).orElse(""), String.class, "Error message of the last running cluster snapshot restore operation on this node.");
        mreg.register("totalPartitions", () -> this.lastOpCtx.totalParts, "The total number of partitions to be restored on this node.");
        mreg.register("processedPartitions", () -> this.lastOpCtx.processedParts.get(), "The number of processed partitions on this node.");
        mreg.register("totalWalSegments", () -> this.lastOpCtx.totalWalSegments, "The total number of WAL segments in the incremental snapshot to be restored on this node.");
        mreg.register("processedWalSegments", () -> this.lastOpCtx.processedWalSegments, "The number of processed WAL segments in the incremental snapshot on this node.");
        mreg.register("processedWalEntries", () -> Optional.ofNullable(this.lastOpCtx.processedWalEntries).map(LongAdder::sum).orElse(-1L), "The number of processed entries from incremental snapshot on this node.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteFutureImpl<Void> start(String snpName, @Nullable String snpPath, @Nullable Collection<String> cacheGrpNames, int incIdx, boolean check) {
        IgniteSnapshotManager.ClusterSnapshotFuture fut0;
        IgniteSnapshotManager snpMgr = this.ctx.cache().context().snapshotMgr();
        try {
            if (this.ctx.clientNode()) {
                throw new IgniteException("Cache group restore operation was rejected. Client nodes can not perform this operation.");
            }
            DiscoveryDataClusterState clusterState = this.ctx.state().clusterState();
            if (clusterState.state() != ClusterState.ACTIVE || clusterState.transition()) {
                throw new IgniteException("Cache group restore operation was rejected. The cluster should be active.");
            }
            if (!clusterState.hasBaselineTopology()) {
                throw new IgniteException("Cache group restore operation was rejected. The baseline topology is not configured for cluster.");
            }
            if (!IgniteFeatures.allNodesSupports(this.ctx.grid().cluster().nodes(), IgniteFeatures.SNAPSHOT_RESTORE_CACHE_GROUP)) {
                throw new IgniteException("Cache group restore operation was rejected. Not all nodes in the cluster support restore operation.");
            }
            if (snpMgr.isSnapshotCreating()) {
                throw new IgniteException("Cache group restore operation was rejected. A cluster snapshot operation is in progress.");
            }
            SnapshotRestoreProcess snapshotRestoreProcess = this;
            synchronized (snapshotRestoreProcess) {
                if (this.restoringSnapshotName() != null) {
                    throw new IgniteException("Cache group restore operation was rejected. The previous snapshot restore operation was not completed.");
                }
                fut0 = this.fut = new IgniteSnapshotManager.ClusterSnapshotFuture(UUID.randomUUID(), snpName, incIdx);
            }
        }
        catch (IgniteException e) {
            snpMgr.recordSnapshotEvent(snpName, "Failed to restore snapshot cache groups: " + e.getMessage(), 173);
            return new IgniteFinishedFutureImpl<Void>(e);
        }
        fut0.listen(f -> {
            if (f.error() != null) {
                snpMgr.recordSnapshotEvent(snpName, "Failed to restore snapshot cache groups: " + f.error().getMessage() + " [reqId=" + fut0.rqId + "].", 173);
            } else {
                snpMgr.recordSnapshotEvent(snpName, "Cache groups have been successfully restored from the snapshot [reqId=" + fut0.rqId + "].", 172);
            }
        });
        String msg = "Cluster-wide snapshot restore operation started [reqId=" + fut0.rqId + ", snpName=" + snpName + (cacheGrpNames == null ? "" : ", caches=" + cacheGrpNames) + (incIdx > 0 ? ", incrementIndex=" + incIdx : "") + ']';
        if (this.log.isInfoEnabled()) {
            this.log.info(msg);
        }
        snpMgr.recordSnapshotEvent(snpName, msg, 171);
        snpMgr.checkSnapshot(snpName, snpPath, cacheGrpNames, true, incIdx, check).listen(f -> {
            if (f.error() != null) {
                this.finishProcess(fut0.rqId, f.error());
                return;
            }
            if (!F.isEmpty(((SnapshotPartitionsVerifyTaskResult)f.result()).exceptions())) {
                this.finishProcess(fut0.rqId, F.first(((SnapshotPartitionsVerifyTaskResult)f.result()).exceptions().values()));
                return;
            }
            if (fut0.interruptEx != null) {
                this.finishProcess(fut0.rqId, fut0.interruptEx);
                return;
            }
            HashSet<UUID> dataNodes = new HashSet<UUID>();
            HashSet<String> snpBltNodes = null;
            Map<ClusterNode, List<SnapshotMetadata>> metas = ((SnapshotPartitionsVerifyTaskResult)f.result()).metas();
            Map reqGrpIds = cacheGrpNames == null ? Collections.emptyMap() : cacheGrpNames.stream().collect(Collectors.toMap(GridCacheUtils::cacheId, v -> v));
            Optional firstMeta = metas.values().iterator().next().stream().findFirst();
            if (!firstMeta.isPresent()) {
                this.finishProcess(fut0.rqId, new IllegalArgumentException("Cache group restore operation was rejected. No snapshot metadata read"));
                return;
            }
            boolean onlyPrimary = ((SnapshotMetadata)firstMeta.get()).onlyPrimary();
            for (Map.Entry<ClusterNode, List<SnapshotMetadata>> entry : metas.entrySet()) {
                dataNodes.add(entry.getKey().id());
                for (SnapshotMetadata meta : entry.getValue()) {
                    assert (meta != null) : entry.getKey().id();
                    if (snpBltNodes == null) {
                        snpBltNodes = new HashSet<String>(meta.baselineNodes());
                    }
                    reqGrpIds.keySet().removeAll(meta.partitions().keySet());
                    if (onlyPrimary == meta.onlyPrimary()) continue;
                    this.finishProcess(fut0.rqId, new IllegalArgumentException("Cache group restore operation was rejected. Only primary value different on nodes"));
                    return;
                }
            }
            if (snpBltNodes == null) {
                this.finishProcess(fut0.rqId, new IllegalArgumentException("Cache group restore operation was rejected. No snapshot data has been found [groups=" + reqGrpIds.values() + ", snapshot=" + snpName + ']'));
                return;
            }
            if (!reqGrpIds.isEmpty()) {
                this.finishProcess(fut0.rqId, new IllegalArgumentException("Cache group restore operation was rejected. Cache group(s) was not found in the snapshot [groups=" + reqGrpIds.values() + ", snapshot=" + snpName + ']'));
                return;
            }
            Collection<UUID> bltNodes = F.viewReadOnly(this.ctx.discovery().discoCache().aliveBaselineNodes(), F.node2id(), new IgnitePredicate[0]);
            SnapshotOperationRequest req = new SnapshotOperationRequest(fut0.rqId, (UUID)F.first(dataNodes), snpName, snpPath, cacheGrpNames, new HashSet<UUID>(bltNodes), false, incIdx, onlyPrimary);
            this.prepareRestoreProc.start(req.requestId(), req);
        });
        return new IgniteFutureImpl<Void>(fut0);
    }

    @Nullable
    public String restoringSnapshotName() {
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (opCtx0 != null) {
            return opCtx0.snpName;
        }
        IgniteSnapshotManager.ClusterSnapshotFuture fut0 = this.fut;
        return fut0 != null ? fut0.name : null;
    }

    public boolean isRestoring(CacheConfiguration<?, ?> ccfg) {
        return this.isRestoring(ccfg, this.opCtx);
    }

    private boolean isRestoring(CacheConfiguration<?, ?> ccfg, @Nullable SnapshotRestoreContext opCtx) {
        assert (ccfg != null);
        if (opCtx == null) {
            return false;
        }
        Map cacheCfgs = opCtx.cfgs;
        String cacheName = ccfg.getName();
        String grpName = ccfg.getGroupName();
        int cacheId = CU.cacheId(cacheName);
        if (cacheCfgs.containsKey(cacheId)) {
            return true;
        }
        for (File grpDir : opCtx.dirs) {
            String locGrpName = FilePageStoreManager.cacheGroupName(grpDir);
            if (grpName != null) {
                if (cacheName.equals(locGrpName)) {
                    return true;
                }
                if (CU.cacheId(locGrpName) != CU.cacheId(grpName)) continue;
                return true;
            }
            if (CU.cacheId(locGrpName) != cacheId) continue;
            return true;
        }
        return false;
    }

    public Set<UUID> cacheStartRequiredAliveNodes(IgniteUuid reqId) {
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (opCtx0 == null || !reqId.globalId().equals(opCtx0.reqId)) {
            return Collections.emptySet();
        }
        return new HashSet<UUID>(opCtx0.nodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishProcess(UUID reqId, @Nullable Throwable err) {
        if (err != null) {
            this.log.error("Failed to restore snapshot cache groups [reqId=" + reqId + "].", err);
        } else if (this.log.isInfoEnabled()) {
            this.log.info("Cache groups have been successfully restored from the snapshot [reqId=" + reqId + "].");
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (opCtx0 != null && reqId.equals(opCtx0.reqId)) {
            this.opCtx = null;
            opCtx0.endTime = U.currentTimeMillis();
        }
        SnapshotRestoreProcess snapshotRestoreProcess = this;
        synchronized (snapshotRestoreProcess) {
            IgniteSnapshotManager.ClusterSnapshotFuture fut0 = this.fut;
            if (fut0 != null && reqId.equals(fut0.rqId)) {
                this.fut = null;
                this.ctx.pools().getSystemExecutorService().submit(() -> fut0.onDone(null, err));
            }
        }
    }

    public void onNodeLeft(UUID leftNodeId) {
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (opCtx0 != null && opCtx0.nodes().contains(leftNodeId)) {
            opCtx0.err.compareAndSet(null, new ClusterTopologyCheckedException("Cache group restore operation was rejected. Required node has left the cluster [nodeId=" + leftNodeId + ']'));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteFuture<Boolean> cancel(UUID reqId, @Deprecated String snpName) {
        boolean ctxStop;
        SnapshotRestoreContext opCtx0;
        assert (reqId == null && snpName != null || reqId != null && snpName == null);
        IgniteCheckedException reason = new IgniteCheckedException("Operation has been canceled by the user.");
        IgniteSnapshotManager.ClusterSnapshotFuture fut0 = null;
        SnapshotRestoreProcess snapshotRestoreProcess = this;
        synchronized (snapshotRestoreProcess) {
            opCtx0 = this.opCtx;
            if (this.fut != null && (this.fut.rqId.equals(reqId) || this.fut.name.equals(snpName))) {
                fut0 = this.fut;
                fut0.interruptEx = reason;
            }
        }
        boolean bl = ctxStop = opCtx0 != null && (opCtx0.reqId.equals(reqId) || opCtx0.snpName.equals(snpName));
        if (ctxStop) {
            this.interrupt(opCtx0, reason);
        }
        return fut0 == null ? new IgniteFinishedFutureImpl<Boolean>(ctxStop) : new IgniteFutureImpl<Boolean>(fut0.chain(f -> true));
    }

    public void interrupt(IgniteCheckedException reason) {
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (opCtx0 != null) {
            this.interrupt(opCtx0, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interrupt(SnapshotRestoreContext opCtx, IgniteCheckedException reason) {
        IgniteFuture stopFut;
        opCtx.err.compareAndSet(null, reason);
        SnapshotRestoreProcess snapshotRestoreProcess = this;
        synchronized (snapshotRestoreProcess) {
            stopFut = opCtx.stopFut;
        }
        if (stopFut != null) {
            stopFut.get();
        }
    }

    private void ensureCacheAbsent(String name) {
        int id = CU.cacheId(name);
        if (this.ctx.cache().cacheGroupDescriptors().containsKey(id) || this.ctx.cache().cacheDescriptor(id) != null) {
            throw new IgniteIllegalStateException("Cache \"" + name + "\" should be destroyed manually before perform restore operation.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<SnapshotRestoreOperationResponse> prepare(SnapshotOperationRequest req) {
        if (this.ctx.clientNode()) {
            return new GridFinishedFuture<SnapshotRestoreOperationResponse>();
        }
        try {
            DiscoveryDataClusterState state = this.ctx.state().clusterState();
            IgniteSnapshotManager snpMgr = this.ctx.cache().context().snapshotMgr();
            if (state.state() != ClusterState.ACTIVE || state.transition()) {
                throw new IgniteCheckedException("Cache group restore operation was rejected. The cluster should be active.");
            }
            if (snpMgr.isSnapshotCreating()) {
                throw new IgniteCheckedException("Cache group restore operation was rejected. A cluster snapshot operation is in progress.");
            }
            if (this.ctx.encryption().isMasterKeyChangeInProgress()) {
                return new GridFinishedFuture<SnapshotRestoreOperationResponse>(new IgniteCheckedException("Cache group restore operation was rejected. Master key changing process is not finished yet."));
            }
            if (this.ctx.encryption().reencryptionInProgress()) {
                return new GridFinishedFuture<SnapshotRestoreOperationResponse>(new IgniteCheckedException("Cache group restore operation was rejected. Caches re-encryption process is not finished yet."));
            }
            for (UUID nodeId : req.nodes()) {
                ClusterNode node = this.ctx.discovery().node(nodeId);
                if (node != null && CU.baselineNode(node, state) && this.ctx.discovery().alive(node)) continue;
                throw new IgniteCheckedException("Cache group restore operation was rejected. Required node has left the cluster [nodeId-" + nodeId + ']');
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Starting local snapshot prepare restore operation [reqId=" + req.requestId() + ", snapshot=" + req.snapshotName() + ", caches=" + req.groups() + ']');
            }
            List<SnapshotMetadata> locMetas = snpMgr.readSnapshotMetadatas(req.snapshotName(), req.snapshotPath());
            SnapshotRestoreContext opCtx0 = this.prepareContext(req, locMetas);
            SnapshotRestoreProcess snapshotRestoreProcess = this;
            synchronized (snapshotRestoreProcess) {
                this.lastOpCtx = this.opCtx = opCtx0;
                IgniteSnapshotManager.ClusterSnapshotFuture fut0 = this.fut;
                if (fut0 != null) {
                    opCtx0.errHnd.accept(fut0.interruptEx);
                }
            }
            for (StoredCacheData cfg : opCtx0.cfgs.values()) {
                this.ensureCacheAbsent(cfg.config().getName());
                if (F.isEmpty(cfg.config().getGroupName())) continue;
                this.ensureCacheAbsent(cfg.config().getGroupName());
            }
            if (this.ctx.isStopping()) {
                throw new NodeStoppingException("The node is stopping: " + this.ctx.localNodeId());
            }
            return new GridFinishedFuture<SnapshotRestoreOperationResponse>(new SnapshotRestoreOperationResponse(opCtx0.cfgs.values(), locMetas));
        }
        catch (RejectedExecutionException | IgniteCheckedException | IgniteIllegalStateException e) {
            this.log.error("Unable to restore cache group(s) from the snapshot [reqId=" + req.requestId() + ", snapshot=" + req.snapshotName() + ']', e);
            return new GridFinishedFuture<SnapshotRestoreOperationResponse>(e);
        }
    }

    static File formatTmpDirName(File cacheDir) {
        return new File(cacheDir.getParent(), TMP_CACHE_DIR_PREFIX + cacheDir.getName());
    }

    static int groupIdFromTmpDir(File tmpCacheDir) {
        assert (tmpCacheDir.getName().startsWith(TMP_CACHE_DIR_PREFIX)) : tmpCacheDir;
        String cacheGrpName = tmpCacheDir.getName().substring(TMP_CACHE_DIR_PREFIX.length());
        return CU.cacheId(FilePageStoreManager.cacheGroupName(new File(tmpCacheDir.getParentFile(), cacheGrpName)));
    }

    private SnapshotRestoreContext prepareContext(SnapshotOperationRequest req, Collection<SnapshotMetadata> metas) throws IgniteCheckedException {
        if (this.opCtx != null) {
            throw new IgniteCheckedException("Cache group restore operation was rejected. The previous snapshot restore operation was not completed.");
        }
        GridCacheSharedContext cctx = this.ctx.cache().context();
        DiscoCache discoCache = this.ctx.discovery().discoCache();
        if (!F.transform(discoCache.aliveBaselineNodes(), F.node2id()).containsAll(req.nodes())) {
            throw new IgniteCheckedException("Restore context cannot be inited since the required baseline nodes missed: " + discoCache);
        }
        DiscoCache discoCache0 = discoCache.copy(discoCache.version(), null);
        if (F.isEmpty(metas)) {
            return new SnapshotRestoreContext(req, discoCache0, Collections.emptyMap());
        }
        if (F.first(metas).pageSize() != cctx.database().pageSize()) {
            throw new IgniteCheckedException("Incompatible memory page size [snapshotPageSize=" + F.first(metas).pageSize() + ", local=" + cctx.database().pageSize() + ", snapshot=" + req.snapshotName() + ", nodeId=" + cctx.localNodeId() + ']');
        }
        HashMap<String, StoredCacheData> cfgsByName = new HashMap<String, StoredCacheData>();
        FilePageStoreManager pageStore = (FilePageStoreManager)cctx.pageStore();
        GridLocalConfigManager locCfgMgr = cctx.cache().configManager();
        boolean skipCompressCheck = false;
        for (SnapshotMetadata meta : metas) {
            for (File snpCacheDir : cctx.snapshotMgr().snapshotCacheDirectories(req.snapshotName(), req.snapshotPath(), meta.folderName(), name -> !"MetaStorage".equals(name))) {
                File tmpCacheDir;
                File cacheDir;
                String grpName = FilePageStoreManager.cacheGroupName(snpCacheDir);
                if (!F.isEmpty(req.groups()) && !req.groups().contains(grpName)) continue;
                if (!skipCompressCheck && meta.isGroupWithCompresion(CU.cacheId(grpName))) {
                    try {
                        File path = this.ctx.pdsFolderResolver().resolveFolders().persistentStoreRootPath();
                        this.ctx.compress().checkPageCompressionSupported(path.toPath(), meta.pageSize());
                    }
                    catch (Exception e) {
                        String grpWithCompr = req.groups().stream().filter(s -> meta.isGroupWithCompresion(CU.cacheId(grpName))).collect(Collectors.joining(", "));
                        String msg = "Requested cache groups [" + grpWithCompr + "] for restore from snapshot '" + meta.snapshotName() + "' are compressed while disk page compression is disabled. To restore these groups please start Ignite with configured disk page compression";
                        throw new IgniteCheckedException(msg);
                    }
                    finally {
                        skipCompressCheck = true;
                    }
                }
                if ((cacheDir = pageStore.cacheWorkDir(snpCacheDir.getName().startsWith("cacheGroup-"), grpName)).exists()) {
                    if (!cacheDir.isDirectory()) {
                        throw new IgniteCheckedException("Unable to restore cache group, file with required directory name already exists [group=" + grpName + ", file=" + cacheDir + ']');
                    }
                    if (cacheDir.list().length > 0) {
                        throw new IgniteCheckedException("Unable to restore cache group - directory is not empty. Cache group should be destroyed manually before perform restore operation [group=" + grpName + ", dir=" + cacheDir + ']');
                    }
                    if (!cacheDir.delete()) {
                        throw new IgniteCheckedException("Unable to remove empty cache directory [group=" + grpName + ", dir=" + cacheDir + ']');
                    }
                }
                if ((tmpCacheDir = SnapshotRestoreProcess.formatTmpDirName(cacheDir)).exists()) {
                    throw new IgniteCheckedException("Unable to restore cache group, temp directory already exists [group=" + grpName + ", dir=" + tmpCacheDir + ']');
                }
                locCfgMgr.readCacheConfigurations(snpCacheDir, cfgsByName);
            }
        }
        Map<Integer, StoredCacheData> cfgsById = cfgsByName.values().stream().collect(Collectors.toMap(v -> CU.cacheId(v.config().getName()), v -> v));
        return new SnapshotRestoreContext(req, discoCache0, cfgsById);
    }

    private void finishPrepare(UUID reqId, Map<UUID, SnapshotRestoreOperationResponse> res, Map<UUID, Throwable> errs) {
        if (this.ctx.clientNode()) {
            return;
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        Throwable failure = F.first(errs.values());
        assert (opCtx0 != null || failure != null) : "Context has not been created on the node " + this.ctx.localNodeId();
        if (opCtx0 == null || !reqId.equals(opCtx0.reqId)) {
            this.finishProcess(reqId, failure);
            return;
        }
        if (failure == null) {
            failure = this.checkNodeLeft(opCtx0.nodes(), res.keySet());
        }
        if (failure != null) {
            opCtx0.errHnd.accept(failure);
            this.finishProcess(reqId, failure);
            return;
        }
        HashMap<Integer, StoredCacheData> globalCfgs = new HashMap<Integer, StoredCacheData>();
        for (Map.Entry<UUID, SnapshotRestoreOperationResponse> e : res.entrySet()) {
            if (e.getValue().ccfgs != null) {
                for (StoredCacheData cacheData : e.getValue().ccfgs) {
                    globalCfgs.put(CU.cacheId(cacheData.config().getName()), cacheData);
                    opCtx0.dirs.add(((FilePageStoreManager)this.ctx.cache().context().pageStore()).cacheWorkDir(cacheData.config()));
                }
            }
            if (!F.isEmpty(e.getValue().metas)) {
                e.getValue().metas.stream().filter(SnapshotMetadata::hasCompressedGroups).forEach(meta -> meta.cacheGroupIds().stream().filter(meta::isGroupWithCompresion).forEach(opCtx0::addCompressedGroup));
            }
            opCtx0.metasPerNode.put(e.getKey(), new ArrayList(e.getValue().metas));
        }
        opCtx0.cfgs = globalCfgs;
        if (U.isLocalNodeCoordinator(this.ctx.discovery())) {
            this.preloadProc.start(reqId, reqId);
        }
    }

    private static GridAffinityAssignmentCache calculateAffinity(GridKernalContext ctx, CacheConfiguration<?, ?> ccfg, DiscoCache cache) {
        GridAffinityAssignmentCache affCache = GridAffinityAssignmentCache.create(ctx, ccfg.getAffinity(), ccfg);
        affCache.calculate(cache.version(), null, cache);
        return affCache;
    }

    @Nullable
    private static SnapshotMetadata findMetadataWithSamePartitions(List<SnapshotMetadata> metas, int grpId, Set<Integer> parts) {
        assert (!F.isEmpty(parts) && !parts.contains(65535)) : parts;
        for (SnapshotMetadata meta : metas) {
            Set<Integer> grpParts = meta.partitions().get(grpId);
            HashSet<Integer> grpWoIndex = grpParts == null ? Collections.emptySet() : new HashSet<Integer>(grpParts);
            grpWoIndex.remove(65535);
            if (!grpWoIndex.equals(parts)) continue;
            return meta;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<Boolean> preload(UUID reqId) {
        if (this.ctx.clientNode()) {
            return new GridFinishedFuture<Boolean>();
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        GridFutureAdapter<Boolean> retFut = new GridFutureAdapter<Boolean>();
        if (opCtx0 == null) {
            return new GridFinishedFuture<Boolean>(new IgniteCheckedException("Snapshot restore process has incorrect restore state: " + reqId));
        }
        if (opCtx0.dirs.isEmpty()) {
            return new GridFinishedFuture<Boolean>();
        }
        try {
            if (this.ctx.isStopping()) {
                throw new NodeStoppingException("Node is stopping: " + this.ctx.localNodeId());
            }
            Set<SnapshotMetadata> allMetas = opCtx0.metasPerNode.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            AbstractSnapshotVerificationTask.checkMissedMetadata(allMetas);
            IgniteSnapshotManager snpMgr = this.ctx.cache().context().snapshotMgr();
            SnapshotRestoreProcess snapshotRestoreProcess = this;
            synchronized (snapshotRestoreProcess) {
                opCtx0.stopFut = new IgniteFutureImpl<Object>(retFut.chain(f -> null));
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Starting snapshot preload operation to restore cache groups [reqId=" + reqId + ", snapshot=" + opCtx0.snpName + ", caches=" + F.transform(opCtx0.dirs, FilePageStoreManager::cacheGroupName) + ']');
            }
            File snpDir = snpMgr.snapshotLocalDir(opCtx0.snpName, opCtx0.snpPath);
            CompletableFuture<Object> metaFut = this.ctx.localNodeId().equals(opCtx0.opNodeId) ? CompletableFuture.runAsync(() -> {
                try {
                    SnapshotMetadata meta = (SnapshotMetadata)F.first((List)opCtx0.metasPerNode.get(opCtx0.opNodeId));
                    File dir = opCtx0.incIdx > 0 ? this.ctx.cache().context().snapshotMgr().incrementalSnapshotLocalDir(opCtx0.snpName, opCtx0.snpPath, opCtx0.incIdx) : snpDir;
                    File binDir = CacheObjectBinaryProcessorImpl.binaryWorkDir(dir.getAbsolutePath(), meta.folderName());
                    File marshallerDir = MarshallerContextImpl.mappingFileStoreWorkDir(dir.getAbsolutePath());
                    this.ctx.cacheObjects().updateMetadata(binDir, opCtx0.stopChecker);
                    this.restoreMappings(marshallerDir, opCtx0.stopChecker);
                }
                catch (Throwable t) {
                    this.log.error("Unable to perform metadata update operation for the cache groups restore process", t);
                    opCtx0.errHnd.accept(t);
                }
            }, snpMgr.snapshotExecutorService()) : CompletableFuture.completedFuture(null);
            HashMap<String, GridAffinityAssignmentCache> affCache = new HashMap<String, GridAffinityAssignmentCache>();
            for (StoredCacheData data : opCtx0.cfgs.values()) {
                affCache.computeIfAbsent(CU.cacheOrGroupName(data.config()), grp -> SnapshotRestoreProcess.calculateAffinity(this.ctx, data.config(), opCtx0.discoCache));
            }
            HashMap<Integer, Set> allParts = new HashMap<Integer, Set>();
            HashMap rmtLoadParts = new HashMap();
            ClusterNode locNode = this.ctx.cache().context().localNode();
            List locMetas = (List)opCtx0.metasPerNode.get(locNode.id());
            block8: for (File dir : opCtx0.dirs) {
                String cacheOrGrpName = FilePageStoreManager.cacheGroupName(dir);
                int n = CU.cacheId(cacheOrGrpName);
                File tmpCacheDir = SnapshotRestoreProcess.formatTmpDirName(dir);
                tmpCacheDir.mkdir();
                HashSet<Integer> availParts = new HashSet<Integer>();
                for (SnapshotMetadata meta : allMetas) {
                    Set<Integer> parts = meta.partitions().get(n);
                    if (parts == null) continue;
                    availParts.addAll(parts);
                }
                List<List<ClusterNode>> assignment = ((GridAffinityAssignmentCache)affCache.get(cacheOrGrpName)).idealAssignment().assignment();
                Set partFuts = availParts.stream().filter(p -> p != 65535 && ((List)assignment.get((int)p)).contains(locNode)).map(p -> new PartitionRestoreFuture((int)p, opCtx0.processedParts)).collect(Collectors.toSet());
                allParts.put(n, partFuts);
                HashSet leftParts = new HashSet(partFuts);
                rmtLoadParts.put(n, leftParts);
                if (leftParts.isEmpty()) continue;
                SnapshotMetadata full = SnapshotRestoreProcess.findMetadataWithSamePartitions(locMetas, n, leftParts.stream().map(p -> ((PartitionRestoreFuture)p).partId).collect(Collectors.toSet()));
                for (SnapshotMetadata snapshotMetadata : full == null ? locMetas : Collections.singleton(full)) {
                    File idxFile;
                    if (leftParts.isEmpty()) continue block8;
                    File snpCacheDir = new File(snpDir, Paths.get(IgniteSnapshotManager.databaseRelativePath(snapshotMetadata.folderName()), dir.getName()).toString());
                    leftParts.removeIf(partFut -> {
                        boolean doCopy = Optional.ofNullable(meta.partitions().get(grpId2)).orElse(Collections.emptySet()).contains(((PartitionRestoreFuture)partFut).partId);
                        if (doCopy) {
                            this.copyLocalAsync(opCtx0, snpCacheDir, tmpCacheDir, (PartitionRestoreFuture)partFut);
                        }
                        return doCopy;
                    });
                    if (snapshotMetadata != full) continue;
                    assert (leftParts.isEmpty()) : leftParts;
                    if (this.log.isInfoEnabled()) {
                        this.log.info("The snapshot was taken on the same cluster topology. The index will be copied to restoring cache group if necessary [reqId=" + reqId + ", snapshot=" + opCtx0.snpName + ", dir=" + dir.getName() + ']');
                    }
                    if (!(idxFile = new File(snpCacheDir, FilePageStoreManager.getPartitionFileName(65535))).exists()) continue;
                    PartitionRestoreFuture idxFut = new PartitionRestoreFuture(65535, opCtx0.processedParts);
                    allParts.computeIfAbsent(n, g -> new HashSet()).add(idxFut);
                    this.copyLocalAsync(opCtx0, snpCacheDir, tmpCacheDir, idxFut);
                }
            }
            List<PartitionRestoreFuture> rmtAwaitParts = rmtLoadParts.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            Map<UUID, Map<Integer, Set<Integer>>> snpAff = SnapshotRestoreProcess.snapshotAffinity(opCtx0.metasPerNode.entrySet().stream().filter(e -> !((UUID)e.getKey()).equals(this.ctx.localNodeId())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), (grpId, partId) -> rmtLoadParts.get(grpId) != null && ((Set)rmtLoadParts.get(grpId)).remove(new PartitionRestoreFuture((int)partId, opCtx0.processedParts)));
            try {
                if (this.log.isInfoEnabled() && !snpAff.isEmpty()) {
                    this.log.info("Trying to request partitions from remote nodes [reqId=" + reqId + ", snapshot=" + opCtx0.snpName + ", map=" + snpAff.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SnapshotRestoreProcess.partitionsMapToString((Map)e.getValue()))) + ']');
                }
                for (Map.Entry entry : snpAff.entrySet()) {
                    this.ctx.cache().context().snapshotMgr().requestRemoteSnapshotFiles((UUID)entry.getKey(), opCtx0.reqId, opCtx0.snpName, opCtx0.snpPath, (Map)entry.getValue(), opCtx0.stopChecker, (snpFile, t) -> {
                        if (opCtx0.stopChecker.getAsBoolean()) {
                            SnapshotRestoreProcess.completeListExceptionally(rmtAwaitParts, new IgniteInterruptedException("Snapshot remote operation request cancelled."));
                            return;
                        }
                        if (t != null) {
                            opCtx0.errHnd.accept(t);
                            SnapshotRestoreProcess.completeListExceptionally(rmtAwaitParts, t);
                            return;
                        }
                        int grpId = SnapshotRestoreProcess.groupIdFromTmpDir(snpFile.getParentFile());
                        int partId = FilePageStoreManager.partId(snpFile.getName());
                        PartitionRestoreFuture partFut = F.find((Iterable)allParts.get(grpId), null, fut -> ((PartitionRestoreFuture)fut).partId == partId);
                        assert (partFut != null) : snpFile.getAbsolutePath();
                        if (!opCtx0.isGroupCompressed(grpId)) {
                            partFut.complete(snpFile.toPath());
                            return;
                        }
                        CompletableFuture.runAsync(() -> {
                            try {
                                this.punchHole(grpId, partId, (File)snpFile);
                                partFut.complete(snpFile.toPath());
                            }
                            catch (Throwable t0) {
                                opCtx0.errHnd.accept(t0);
                                SnapshotRestoreProcess.completeListExceptionally(rmtAwaitParts, t0);
                            }
                        }, snpMgr.snapshotExecutorService());
                    });
                }
            }
            catch (IgniteCheckedException e2) {
                opCtx0.errHnd.accept(e2);
                SnapshotRestoreProcess.completeListExceptionally(rmtAwaitParts, e2);
            }
            List<CompletableFuture> allPartFuts = allParts.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            int n = allPartFuts.size();
            opCtx0.totalParts = n;
            ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(allPartFuts.toArray(new CompletableFuture[n])).runAfterBothAsync(metaFut, () -> {
                try {
                    if (opCtx0.stopChecker.getAsBoolean()) {
                        throw new IgniteInterruptedException("The operation has been stopped on temporary directory switch.");
                    }
                    for (File src : opCtx0.dirs) {
                        Files.move(SnapshotRestoreProcess.formatTmpDirName(src).toPath(), src.toPath(), StandardCopyOption.ATOMIC_MOVE);
                    }
                }
                catch (IOException e) {
                    throw new IgniteException(e);
                }
            }, (Executor)snpMgr.snapshotExecutorService())).whenComplete((r, t) -> opCtx0.errHnd.accept(t))).whenComplete((res, t) -> {
                Throwable t0 = Optional.ofNullable(opCtx0.err.get()).orElse(t);
                if (t0 == null) {
                    retFut.onDone(true);
                } else {
                    this.log.error("Unable to restore cache group(s) from a snapshot [reqId=" + this.opCtx.reqId + ", snapshot=" + this.opCtx.snpName + ']', t0);
                    retFut.onDone(t0);
                }
            });
        }
        catch (Exception ex) {
            opCtx0.errHnd.accept(ex);
            return new GridFinishedFuture<Boolean>(ex);
        }
        return retFut;
    }

    private void restoreMappings(File marshallerDir, BooleanSupplier stopChecker) throws IgniteCheckedException {
        File[] mappings = marshallerDir.listFiles(BinaryUtils::notTmpFile);
        if (mappings == null) {
            throw new IgniteException("Failed to list marshaller directory [dir=" + marshallerDir + ']');
        }
        for (File map : mappings) {
            if (stopChecker.getAsBoolean()) {
                return;
            }
            if (Thread.interrupted()) {
                throw new IgniteInterruptedCheckedException("Thread has been interrupted.");
            }
            String fileName = map.getName();
            int typeId = BinaryUtils.mappedTypeId(fileName);
            byte platformId = BinaryUtils.mappedFilePlatformId(fileName);
            BinaryContext binCtx = ((CacheObjectBinaryProcessorImpl)this.ctx.cacheObjects()).binaryContext();
            binCtx.registerUserClassName(typeId, BinaryUtils.readMapping(map), false, false, platformId);
        }
    }

    private void finishPreload(UUID reqId, Map<UUID, Boolean> res, Map<UUID, Throwable> errs) {
        if (this.ctx.clientNode()) {
            return;
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        Throwable failure = errs.values().stream().findFirst().orElse(this.checkNodeLeft(opCtx0.nodes(), res.keySet()));
        opCtx0.errHnd.accept(failure);
        if (failure != null) {
            if (U.isLocalNodeCoordinator(this.ctx.discovery())) {
                this.rollbackRestoreProc.start(reqId, reqId);
            }
            return;
        }
        if (U.isLocalNodeCoordinator(this.ctx.discovery())) {
            this.cacheStartProc.start(reqId, reqId);
        }
    }

    private IgniteInternalFuture<Boolean> cacheStart(UUID reqId) {
        if (this.ctx.clientNode()) {
            return new GridFinishedFuture<Boolean>();
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        Throwable err = (Throwable)opCtx0.err.get();
        if (err != null) {
            return new GridFinishedFuture<Boolean>(err);
        }
        if (!U.isLocalNodeCoordinator(this.ctx.discovery())) {
            return new GridFinishedFuture<Boolean>();
        }
        Collection<StoredCacheData> ccfgs = opCtx0.cfgs.values();
        if (this.log.isInfoEnabled()) {
            this.log.info("Starting restored caches [reqId=" + opCtx0.reqId + ", snapshot=" + opCtx0.snpName + ", caches=" + F.viewReadOnly(ccfgs, c -> c.config().getName(), new IgnitePredicate[0]) + ']');
        }
        return this.ctx.cache().dynamicStartCachesByStoredConf(ccfgs, true, true, false, IgniteUuid.fromUuid(reqId));
    }

    private void finishCacheStart(UUID reqId, Map<UUID, Boolean> res, Map<UUID, Throwable> errs) {
        if (this.ctx.clientNode()) {
            return;
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        Throwable failure = errs.values().stream().findFirst().orElse(this.checkNodeLeft(opCtx0.nodes(), res.keySet()));
        if (failure == null) {
            if (opCtx0.incIdx > 0) {
                if (U.isLocalNodeCoordinator(this.ctx.discovery())) {
                    this.incSnpRestoreProc.start(reqId, reqId);
                }
                return;
            }
            this.finishProcess(reqId, null);
            return;
        }
        opCtx0.err.compareAndSet(null, failure);
        if (U.isLocalNodeCoordinator(this.ctx.discovery())) {
            this.rollbackRestoreProc.start(reqId, reqId);
        }
    }

    private IgniteInternalFuture<Boolean> cacheStop(UUID reqId) {
        if (!U.isLocalNodeCoordinator(this.ctx.discovery())) {
            return new GridFinishedFuture<Boolean>();
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        Collection stopCaches = opCtx0.cfgs.values().stream().map(c -> c.config().getName()).collect(Collectors.toSet());
        if (this.log.isInfoEnabled()) {
            this.log.info("Stopping caches [reqId=" + opCtx0.reqId + ", caches=" + stopCaches + ']');
        }
        return this.ctx.cache().dynamicDestroyCaches(stopCaches, false, false).chain(fut -> {
            if (fut.error() != null) {
                throw F.wrap(fut.error());
            }
            return true;
        });
    }

    private void finishCacheStop(UUID reqId, Map<UUID, Boolean> res, Map<UUID, Throwable> errs) {
        if (this.ctx.clientNode()) {
            return;
        }
        if (!errs.isEmpty()) {
            SnapshotRestoreContext opCtx0 = this.opCtx;
            this.log.error("Failed to stop caches during a snapshot rollback routine [reqId=" + opCtx0.reqId + ", err=" + errs + ']');
        }
        if (U.isLocalNodeCoordinator(this.ctx.discovery())) {
            this.rollbackRestoreProc.start(reqId, reqId);
        }
    }

    private IgniteInternalFuture<Boolean> incrementalSnapshotRestore(UUID reqId) {
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (this.ctx.clientNode() || opCtx0 == null || !opCtx0.nodes().contains(this.ctx.localNodeId())) {
            return new GridFinishedFuture<Boolean>();
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Starting incremental snapshot restore operation [reqId=" + opCtx0.reqId + ", snpName=" + opCtx0.snpName + ", incrementIndex=" + opCtx0.incIdx + ", caches=" + F.viewReadOnly(opCtx0.cfgs, c -> c.config().getName(), new IgnitePredicate[0]) + ']');
        }
        GridFutureAdapter<Boolean> res = new GridFutureAdapter<Boolean>();
        this.ctx.pools().getSnapshotExecutorService().submit(() -> {
            try {
                Set<Integer> cacheIds = opCtx0.cfgs.keySet();
                this.walEnabled(false, cacheIds);
                this.restoreIncrementalSnapshot(cacheIds);
                this.walEnabled(true, cacheIds);
                CheckpointProgress cp = this.ctx.cache().context().database().forceNewCheckpoint("Incremental snapshot restored.", fut -> {
                    if (fut.error() != null) {
                        res.onDone(fut.error());
                    } else {
                        res.onDone(true);
                    }
                });
                if (cp == null) {
                    res.onDone(new IgniteCheckedException("Node is stopping."));
                }
            }
            catch (Throwable e) {
                res.onDone(e);
            }
        });
        return res;
    }

    private void restoreIncrementalSnapshot(Set<Integer> cacheIds) throws IgniteCheckedException, IOException {
        final SnapshotRestoreContext opCtx0 = this.opCtx;
        IncrementalSnapshotProcessor incSnpProc = new IncrementalSnapshotProcessor(this.ctx.cache().context(), opCtx0.snpName, opCtx0.snpPath, opCtx0.incIdx, cacheIds){

            @Override
            void totalWalSegments(int segCnt) {
                opCtx0.totalWalSegments = segCnt;
            }

            @Override
            void processedWalSegments(int segCnt) {
                opCtx0.processedWalSegments = segCnt;
            }

            @Override
            void initWalEntries(LongAdder entriesCnt) {
                opCtx0.processedWalEntries = entriesCnt;
            }
        };
        CacheStripedExecutor exec = new CacheStripedExecutor(this.ctx.pools().getStripedExecutorService());
        long start = U.currentTimeMillis();
        incSnpProc.process(e -> {
            GridCacheContext cacheCtx = this.ctx.cache().context().cacheContext(e.cacheId());
            GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)this.ctx.cache().context().database();
            exec.submit(() -> {
                try {
                    this.applyDataEntry(dbMgr, cacheCtx, (DataEntry)e);
                }
                catch (IgniteCheckedException err) {
                    U.error(this.log, "Failed to apply data entry [entry=" + e + ']');
                    exec.onError(err);
                }
            }, cacheCtx.groupId(), e.partitionId());
        }, null);
        exec.awaitApplyComplete();
        for (int cacheId : cacheIds) {
            GridCacheContext cacheCtx = this.ctx.cache().context().cacheContext(cacheId);
            for (int part = 0; part < cacheCtx.topology().partitions(); ++part) {
                int partId = part;
                exec.submit(() -> {
                    GridDhtLocalPartition locPart = cacheCtx.topology().localPartition(partId);
                    if (locPart != null) {
                        locPart.finalizeUpdateCounters();
                    }
                }, cacheCtx.groupId(), part);
            }
        }
        exec.awaitApplyComplete();
        if (this.log.isInfoEnabled()) {
            this.log.info("Finished restore incremental snapshot [snpName=" + opCtx0.snpName + ", incrementIndex=" + opCtx0.incIdx + ", id=" + opCtx0.reqId + ", updatesApplied=" + opCtx0.processedWalEntries.longValue() + ", time=" + (U.currentTimeMillis() - start) + " ms]");
        }
    }

    private void walEnabled(boolean enabled, Set<Integer> cacheIds) {
        for (Integer cacheId : cacheIds) {
            int grpId = this.ctx.cache().cacheDescriptor(cacheId).groupId();
            CacheGroupContext grp = this.ctx.cache().cacheGroup(grpId);
            assert (grp != null) : "cacheId=" + cacheId + " grpId=" + grpId;
            grp.localWalEnabled(enabled, false);
            if (enabled) continue;
            this.ctx.cache().context().database().lastCheckpointInapplicableForWalRebalance(grpId);
        }
    }

    private void applyDataEntry(GridCacheDatabaseSharedManager dbMgr, GridCacheContext<?, ?> cacheCtx, DataEntry dataEntry) throws IgniteCheckedException {
        int partId = dataEntry.partitionId();
        if (partId == -1) {
            U.warn(this.log, "Partition isn't set for read data entry [entry=" + dataEntry + ']');
            partId = cacheCtx.affinity().partition(dataEntry.key());
        }
        GridDhtLocalPartition locPart = cacheCtx.topology().localPartition(partId);
        assert (locPart != null) : "Missed local partition " + partId;
        if (dbMgr.applyDataEntry(cacheCtx, locPart, dataEntry)) {
            cacheCtx.offheap().dataStore(locPart).updateCounter(dataEntry.partitionCounter() - 1L, 1L);
        }
    }

    private void finishIncrementalSnapshotRestore(UUID reqId, Map<UUID, Boolean> res, Map<UUID, Throwable> errs) {
        if (this.ctx.clientNode()) {
            return;
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        Throwable failure = errs.values().stream().findFirst().orElse(this.checkNodeLeft(opCtx0.nodes(), res.keySet()));
        if (failure == null) {
            if (this.fut != null) {
                Set<String> cacheGrps = opCtx0.cfgs.keySet().stream().map(cacheId -> CU.cacheOrGroupName(this.ctx.cache().cacheDescriptor((int)cacheId).cacheConfiguration())).collect(Collectors.toSet());
                this.ctx.cache().context().snapshotMgr().warnAtomicCachesInIncrementalSnapshot(opCtx0.snpName, opCtx0.incIdx, cacheGrps);
            }
            this.finishProcess(reqId, null);
            return;
        }
        opCtx0.err.compareAndSet(null, failure);
        if (U.isLocalNodeCoordinator(this.ctx.discovery())) {
            this.cacheStopProc.start(reqId, reqId);
        }
    }

    private static Map<UUID, Map<Integer, Set<Integer>>> snapshotAffinity(Map<UUID, List<SnapshotMetadata>> metas, BiPredicate<Integer, Integer> filter) {
        HashMap<UUID, Map<Integer, Set<Integer>>> nodeToSnp = new HashMap<UUID, Map<Integer, Set<Integer>>>();
        ArrayList<UUID> nodes = new ArrayList<UUID>(metas.keySet());
        Collections.shuffle(nodes);
        LinkedHashMap shuffleMetas = new LinkedHashMap();
        nodes.forEach(k -> {
            List cfr_ignored_0 = (List)shuffleMetas.put(k, metas.get(k));
        });
        for (Map.Entry e : shuffleMetas.entrySet()) {
            UUID nodeId = (UUID)e.getKey();
            for (SnapshotMetadata meta : Optional.ofNullable(e.getValue()).orElse(Collections.emptyList())) {
                Map parts = Optional.ofNullable(meta.partitions()).orElse(Collections.emptyMap());
                for (Map.Entry metaParts : parts.entrySet()) {
                    for (Integer partId : (Set)metaParts.getValue()) {
                        if (!filter.test((Integer)metaParts.getKey(), partId)) continue;
                        nodeToSnp.computeIfAbsent(nodeId, n -> new HashMap()).computeIfAbsent(metaParts.getKey(), k -> new HashSet()).add(partId);
                    }
                }
            }
        }
        return nodeToSnp;
    }

    private Exception checkNodeLeft(Collection<UUID> reqNodes, Set<UUID> respNodes) {
        if (!respNodes.containsAll(reqNodes)) {
            HashSet<UUID> leftNodes = new HashSet<UUID>(reqNodes);
            leftNodes.removeAll(respNodes);
            return new ClusterTopologyCheckedException("Cache group restore operation was rejected. Required node has left the cluster [nodeId=" + leftNodes + ']');
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<Boolean> rollback(UUID reqId) {
        if (this.ctx.clientNode()) {
            return new GridFinishedFuture<Boolean>();
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (opCtx0 == null || F.isEmpty(opCtx0.dirs)) {
            return new GridFinishedFuture<Boolean>();
        }
        GridFutureAdapter<Boolean> retFut = new GridFutureAdapter<Boolean>();
        SnapshotRestoreProcess snapshotRestoreProcess = this;
        synchronized (snapshotRestoreProcess) {
            opCtx0.stopFut = new IgniteFutureImpl<Object>(retFut.chain(f -> null));
        }
        try {
            this.ctx.cache().context().snapshotMgr().snapshotExecutorService().execute(() -> {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Removing restored cache directories [reqId=" + reqId + ", snapshot=" + opCtx0.snpName + ", dirs=" + opCtx0.dirs + ']');
                }
                IgniteCheckedException ex = null;
                for (File cacheDir : opCtx0.dirs) {
                    File tmpCacheDir = SnapshotRestoreProcess.formatTmpDirName(cacheDir);
                    if (tmpCacheDir.exists() && !U.delete(tmpCacheDir)) {
                        this.log.error("Unable to perform rollback routine completely, cannot remove temp directory [reqId=" + reqId + ", snapshot=" + opCtx0.snpName + ", dir=" + tmpCacheDir + ']');
                        ex = new IgniteCheckedException("Unable to remove temporary cache directory " + cacheDir);
                    }
                    if (!cacheDir.exists() || U.delete(cacheDir)) continue;
                    this.log.error("Unable to perform rollback routine completely, cannot remove cache directory [reqId=" + reqId + ", snapshot=" + opCtx0.snpName + ", dir=" + cacheDir + ']');
                    ex = new IgniteCheckedException("Unable to remove cache directory " + cacheDir);
                }
                if (ex != null) {
                    retFut.onDone(ex);
                } else {
                    retFut.onDone(true);
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.log.error("Unable to perform rollback routine, task has been rejected [reqId=" + reqId + ", snapshot=" + opCtx0.snpName + ']');
            retFut.onDone(e);
        }
        return retFut;
    }

    private void finishRollback(UUID reqId, Map<UUID, Boolean> res, Map<UUID, Throwable> errs) {
        if (this.ctx.clientNode()) {
            return;
        }
        if (!errs.isEmpty()) {
            this.log.warning("Some nodes were unable to complete the rollback routine completely, check the local log files for more information [nodeIds=" + errs.keySet() + ']');
        }
        SnapshotRestoreContext opCtx0 = this.opCtx;
        if (!res.keySet().containsAll(opCtx0.nodes())) {
            HashSet<UUID> leftNodes = new HashSet<UUID>(opCtx0.nodes());
            leftNodes.removeAll(res.keySet());
            this.log.warning("Some of the nodes left the cluster and were unable to complete the rollback operation [reqId=" + reqId + ", snapshot=" + opCtx0.snpName + ", node(s)=" + leftNodes + ']');
        }
        this.finishProcess(reqId, (Throwable)opCtx0.err.get());
    }

    private void copyLocalAsync(SnapshotRestoreContext opCtx, File srcDir, File targetDir, PartitionRestoreFuture partFut) {
        File snpFile = new File(srcDir, FilePageStoreManager.getPartitionFileName(partFut.partId));
        Path partFile = Paths.get(targetDir.getAbsolutePath(), FilePageStoreManager.getPartitionFileName(partFut.partId));
        int grpId = SnapshotRestoreProcess.groupIdFromTmpDir(targetDir);
        IgniteSnapshotManager snapMgr = this.ctx.cache().context().snapshotMgr();
        CompletionStage<Path> copyPartFut = CompletableFuture.supplyAsync(() -> {
            if (opCtx.stopChecker.getAsBoolean()) {
                throw new IgniteInterruptedException("The operation has been stopped on copy file: " + snpFile.getAbsolutePath());
            }
            if (Thread.interrupted()) {
                throw new IgniteInterruptedException("Thread has been interrupted: " + Thread.currentThread().getName());
            }
            if (!snpFile.exists()) {
                throw new IgniteException("Partition snapshot file doesn't exist [snpName=" + opCtx.snpName + ", snpDir=" + snpFile.getAbsolutePath() + ", name=" + snpFile.getName() + ']');
            }
            IgniteSnapshotManager.copy(snapMgr.ioFactory(), snpFile, partFile.toFile(), snpFile.length());
            return partFile;
        }, snapMgr.snapshotExecutorService());
        if (opCtx.isGroupCompressed(grpId)) {
            copyPartFut = copyPartFut.thenComposeAsync(p -> {
                CompletableFuture<Path> result = new CompletableFuture<Path>();
                try {
                    this.punchHole(grpId, partFut.partId, partFile.toFile());
                    result.complete(partFile);
                }
                catch (Throwable t) {
                    result.completeExceptionally(t);
                }
                return result;
            }, (Executor)snapMgr.snapshotExecutorService());
        }
        ((CompletableFuture)copyPartFut.whenComplete((r, t) -> opCtx.errHnd.accept(t))).whenComplete((r, t) -> {
            if (t == null) {
                partFut.complete(partFile);
            } else {
                partFut.completeExceptionally((Throwable)t);
            }
        });
    }

    private void punchHole(int grpId, int partId, File partFile) throws Exception {
        FilePageStoreManager storeMgr = (FilePageStoreManager)this.ctx.cache().context().pageStore();
        FileVersionCheckingFactory factory = storeMgr.getPageStoreFactory(grpId, null);
        try (FilePageStore pageStore = (FilePageStore)factory.createPageStore(GroupPartitionId.getTypeByPartId(partId), partFile, val -> {});){
            pageStore.init();
            ByteBuffer buf = this.locBuff.get();
            long pageId = PageIdUtils.pageId(partId, (byte)0, 0);
            for (int pageNo = 0; pageNo < pageStore.pages(); ++pageNo) {
                short comprPageSz;
                if (this.opCtx.stopChecker.getAsBoolean()) {
                    throw new IgniteInterruptedException("The operation has been stopped while punching holes in file: " + partFile.getAbsolutePath());
                }
                if (Thread.interrupted()) {
                    throw new IgniteInterruptedException("Thread has been interrupted: " + Thread.currentThread().getName());
                }
                buf.clear();
                pageStore.read(pageId, buf, true);
                if (PageIO.getCompressionType(buf) != 0 && (comprPageSz = PageIO.getCompressedSize(buf)) < pageStore.getPageSize()) {
                    pageStore.punchHole(pageId, comprPageSz);
                }
                ++pageId;
            }
        }
    }

    private static void completeListExceptionally(List<PartitionRestoreFuture> col, Throwable ex) {
        for (PartitionRestoreFuture f : col) {
            f.completeExceptionally(ex);
        }
    }

    private static String partitionsMapToString(Map<Integer, Set<Integer>> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> S.toStringSortedDistinct((Collection)e.getValue()))).toString();
    }

    private static class PartitionRestoreFuture
    extends CompletableFuture<Path> {
        private final int partId;
        private final AtomicInteger cntr;

        private PartitionRestoreFuture(int partId, AtomicInteger cntr) {
            this.partId = partId;
            this.cntr = cntr;
        }

        @Override
        public boolean complete(Path path) {
            this.cntr.incrementAndGet();
            return super.complete(path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionRestoreFuture future = (PartitionRestoreFuture)o;
            return this.partId == future.partId;
        }

        public int hashCode() {
            return Objects.hash(this.partId);
        }

        @Override
        public String toString() {
            return S.toString(PartitionRestoreFuture.class, this);
        }
    }

    private static class SnapshotRestoreOperationResponse
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final List<StoredCacheData> ccfgs;
        private final List<SnapshotMetadata> metas;

        public SnapshotRestoreOperationResponse(Collection<StoredCacheData> ccfgs, Collection<SnapshotMetadata> metas) {
            this.ccfgs = new ArrayList<StoredCacheData>(ccfgs);
            this.metas = new ArrayList<SnapshotMetadata>(metas);
        }
    }

    private static class SnapshotRestoreContext {
        private final UUID reqId;
        private final String snpName;
        private final String snpPath;
        private final DiscoCache discoCache;
        private final UUID opNodeId;
        private final int incIdx;
        private final Set<File> dirs = new HashSet<File>();
        private final AtomicReference<Throwable> err = new AtomicReference();
        private final Map<UUID, List<SnapshotMetadata>> metasPerNode = new HashMap<UUID, List<SnapshotMetadata>>();
        private final Consumer<Throwable> errHnd = ex -> this.err.compareAndSet((Throwable)null, (Throwable)ex);
        private final BooleanSupplier stopChecker = () -> this.err.get() != null;
        private final Set<Integer> comprGrps = new HashSet<Integer>();
        private volatile Map<Integer, StoredCacheData> cfgs = Collections.emptyMap();
        private volatile IgniteFuture<?> stopFut;
        private final long startTime;
        private final AtomicInteger processedParts = new AtomicInteger(0);
        private volatile int totalParts = -1;
        private volatile long endTime;
        private volatile int totalWalSegments = -1;
        private volatile int processedWalSegments = -1;
        private volatile LongAdder processedWalEntries;

        protected SnapshotRestoreContext() {
            this.reqId = null;
            this.snpName = "";
            this.startTime = 0L;
            this.opNodeId = null;
            this.discoCache = null;
            this.snpPath = null;
            this.incIdx = 0;
        }

        protected SnapshotRestoreContext(SnapshotOperationRequest req, DiscoCache discoCache, Map<Integer, StoredCacheData> cfgs) {
            this.reqId = req.requestId();
            this.snpName = req.snapshotName();
            this.snpPath = req.snapshotPath();
            this.opNodeId = req.operationalNodeId();
            this.incIdx = req.incrementIndex();
            this.startTime = U.currentTimeMillis();
            this.discoCache = discoCache;
            this.cfgs = cfgs;
        }

        public Collection<UUID> nodes() {
            return F.transform(this.discoCache.aliveBaselineNodes(), F.node2id());
        }

        public boolean isGroupCompressed(int grpId) {
            return this.comprGrps.contains(grpId);
        }

        void addCompressedGroup(int grpId) {
            this.comprGrps.add(grpId);
        }
    }
}

