/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerType;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyHandler;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotWarningException;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionKeyV2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgnitePredicate;

public class SnapshotPartitionsQuickVerifyHandler
extends SnapshotPartitionsVerifyHandler {
    public static final String WRN_MSG = "This may happen if DataStreamer with property 'allowOverwrite' set to `false` is loading during the snapshot or hadn't successfully finished earlier. However, you will be able restore rest the caches from this snapshot.";

    public SnapshotPartitionsQuickVerifyHandler(GridCacheSharedContext<?, ?> cctx) {
        super(cctx);
    }

    @Override
    public SnapshotHandlerType type() {
        return SnapshotHandlerType.CREATE;
    }

    @Override
    public Map<PartitionKeyV2, PartitionHashRecordV2> invoke(SnapshotHandlerContext opCtx) throws IgniteCheckedException {
        if (opCtx.streamerWarning()) {
            return null;
        }
        Object res = super.invoke(opCtx);
        assert (res != null);
        return res;
    }

    @Override
    public void complete(String name, Collection<SnapshotHandlerResult<Map<PartitionKeyV2, PartitionHashRecordV2>>> results) throws IgniteCheckedException {
        if (results.stream().anyMatch(r -> r.data() == null)) {
            return;
        }
        HashSet wrnGrps = new HashSet();
        HashMap total = new HashMap();
        F.viewReadOnly(results, SnapshotHandlerResult::data, new IgnitePredicate[0]).forEach(m -> m.forEach((part, val) -> {
            PartitionHashRecordV2 other = total.putIfAbsent(part, val);
            if (other == null) {
                return;
            }
            if (val.size() != other.size() || !Objects.equals(val.updateCounter(), other.updateCounter())) {
                wrnGrps.add(part.groupId());
            }
        }));
        if (!wrnGrps.isEmpty()) {
            throw new SnapshotWarningException("Cache partitions differ for cache groups " + S.toStringSortedDistinct(wrnGrps) + ". " + WRN_MSG);
        }
    }

    @Override
    protected boolean skipHash() {
        return true;
    }
}

